/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSweeping;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentManager {
    private static final String TAG_ENCH_ID = "id";
    private static final String TAG_ENCH_LEVEL = "lvl";
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static NBTTagCompound storeEnchantment(@Nullable MinecraftKey var0, int var1) {
        NBTTagCompound var2 = new NBTTagCompound();
        var2.putString(TAG_ENCH_ID, String.valueOf(var0));
        var2.putShort(TAG_ENCH_LEVEL, (short)var1);
        return var2;
    }

    public static void setEnchantmentLevel(NBTTagCompound var0, int var1) {
        var0.putShort(TAG_ENCH_LEVEL, (short)var1);
    }

    public static int getEnchantmentLevel(NBTTagCompound var0) {
        return MathHelper.clamp(var0.getInt(TAG_ENCH_LEVEL), 0, 255);
    }

    @Nullable
    public static MinecraftKey getEnchantmentId(NBTTagCompound var0) {
        return MinecraftKey.tryParse(var0.getString(TAG_ENCH_ID));
    }

    @Nullable
    public static MinecraftKey getEnchantmentId(Enchantment var0) {
        return BuiltInRegistries.ENCHANTMENT.getKey(var0);
    }

    public static int getItemEnchantmentLevel(Enchantment var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return 0;
        }
        MinecraftKey var2 = EnchantmentManager.getEnchantmentId(var0);
        NBTTagList var3 = var1.getEnchantmentTags();
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            NBTTagCompound var5 = var3.getCompound(var4);
            MinecraftKey var6 = EnchantmentManager.getEnchantmentId(var5);
            if (var6 == null || !var6.equals(var2)) continue;
            return EnchantmentManager.getEnchantmentLevel(var5);
        }
        return 0;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack var0) {
        NBTTagList var1 = var0.is(Items.ENCHANTED_BOOK) ? ItemEnchantedBook.getEnchantments(var0) : var0.getEnchantmentTags();
        return EnchantmentManager.deserializeEnchantments(var1);
    }

    public static Map<Enchantment, Integer> deserializeEnchantments(NBTTagList var0) {
        LinkedHashMap var1 = Maps.newLinkedHashMap();
        for (int var22 = 0; var22 < var0.size(); ++var22) {
            NBTTagCompound var3 = var0.getCompound(var22);
            BuiltInRegistries.ENCHANTMENT.getOptional(EnchantmentManager.getEnchantmentId(var3)).ifPresent(var2 -> var1.put(var2, EnchantmentManager.getEnchantmentLevel(var3)));
        }
        return var1;
    }

    public static void setEnchantments(Map<Enchantment, Integer> var0, ItemStack var1) {
        NBTTagList var2 = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> var4 : var0.entrySet()) {
            Enchantment var5 = var4.getKey();
            if (var5 == null) continue;
            int var6 = var4.getValue();
            var2.add(EnchantmentManager.storeEnchantment(EnchantmentManager.getEnchantmentId(var5), var6));
            if (!var1.is(Items.ENCHANTED_BOOK)) continue;
            ItemEnchantedBook.addEnchantment(var1, new WeightedRandomEnchant(var5, var6));
        }
        if (var2.isEmpty()) {
            var1.removeTagKey("Enchantments");
        } else if (!var1.is(Items.ENCHANTED_BOOK)) {
            var1.addTagElement("Enchantments", var2);
        }
    }

    private static void runIterationOnItem(a var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return;
        }
        NBTTagList var22 = var1.getEnchantmentTags();
        for (int var3 = 0; var3 < var22.size(); ++var3) {
            NBTTagCompound var4 = var22.getCompound(var3);
            BuiltInRegistries.ENCHANTMENT.getOptional(EnchantmentManager.getEnchantmentId(var4)).ifPresent(var2 -> var0.accept((Enchantment)var2, EnchantmentManager.getEnchantmentLevel(var4)));
        }
    }

    private static void runIterationOnInventory(a var0, Iterable<ItemStack> var1) {
        for (ItemStack var3 : var1) {
            EnchantmentManager.runIterationOnItem(var0, var3);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> var0, DamageSource var1) {
        MutableInt var22 = new MutableInt();
        EnchantmentManager.runIterationOnInventory((var2, var3) -> var22.add(var2.getDamageProtection(var3, var1)), var0);
        return var22.intValue();
    }

    public static float getDamageBonus(ItemStack var0, EnumMonsterType var1) {
        MutableFloat var22 = new MutableFloat();
        EnchantmentManager.runIterationOnItem((var2, var3) -> var22.add(var2.getDamageBonus(var3, var1)), var0);
        return var22.floatValue();
    }

    public static float getSweepingDamageRatio(EntityLiving var0) {
        int var1 = EnchantmentManager.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, var0);
        if (var1 > 0) {
            return EnchantmentSweeping.getSweepingDamageRatio(var1);
        }
        return 0.0f;
    }

    public static void doPostHurtEffects(EntityLiving var0, Entity var1) {
        a var22 = (var2, var3) -> var2.doPostHurt(var0, var1, var3);
        if (var0 != null) {
            EnchantmentManager.runIterationOnInventory(var22, var0.getAllSlots());
        }
        if (var1 instanceof EntityHuman) {
            EnchantmentManager.runIterationOnItem(var22, var0.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(EntityLiving var0, Entity var1) {
        a var22 = (var2, var3) -> var2.doPostAttack(var0, var1, var3);
        if (var0 != null) {
            EnchantmentManager.runIterationOnInventory(var22, var0.getAllSlots());
        }
        if (var0 instanceof EntityHuman) {
            EnchantmentManager.runIterationOnItem(var22, var0.getMainHandItem());
        }
    }

    public static int getEnchantmentLevel(Enchantment var0, EntityLiving var1) {
        Collection<ItemStack> var2 = var0.getSlotItems(var1).values();
        if (var2 == null) {
            return 0;
        }
        int var3 = 0;
        for (ItemStack var5 : var2) {
            int var6 = EnchantmentManager.getItemEnchantmentLevel(var0, var5);
            if (var6 <= var3) continue;
            var3 = var6;
        }
        return var3;
    }

    public static float getSneakingSpeedBonus(EntityLiving var0) {
        return (float)EnchantmentManager.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, var0) * 0.15f;
    }

    public static int getKnockbackBonus(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.KNOCKBACK, var0);
    }

    public static int getFireAspect(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.FIRE_ASPECT, var0);
    }

    public static int getRespiration(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.RESPIRATION, var0);
    }

    public static int getDepthStrider(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, var0);
    }

    public static int getBlockEfficiency(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.BLOCK_EFFICIENCY, var0);
    }

    public static int getFishingLuckBonus(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.FISHING_LUCK, var0);
    }

    public static int getFishingSpeedBonus(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.FISHING_SPEED, var0);
    }

    public static int getMobLooting(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.MOB_LOOTING, var0);
    }

    public static boolean hasAquaAffinity(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, var0) > 0;
    }

    public static boolean hasFrostWalker(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.FROST_WALKER, var0) > 0;
    }

    public static boolean hasSoulSpeed(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.SOUL_SPEED, var0) > 0;
    }

    public static boolean hasBindingCurse(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, var0) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, var0) > 0;
    }

    public static int getLoyalty(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.LOYALTY, var0);
    }

    public static int getRiptide(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.RIPTIDE, var0);
    }

    public static boolean hasChanneling(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.CHANNELING, var0) > 0;
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> getRandomItemWith(Enchantment var02, EntityLiving var1) {
        return EnchantmentManager.getRandomItemWith(var02, var1, var0 -> true);
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> getRandomItemWith(Enchantment var0, EntityLiving var1, Predicate<ItemStack> var2) {
        Map<EnumItemSlot, ItemStack> var3 = var0.getSlotItems(var1);
        if (var3.isEmpty()) {
            return null;
        }
        ArrayList var4 = Lists.newArrayList();
        for (Map.Entry<EnumItemSlot, ItemStack> var6 : var3.entrySet()) {
            ItemStack var7 = var6.getValue();
            if (var7.isEmpty() || EnchantmentManager.getItemEnchantmentLevel(var0, var7) <= 0 || !var2.test(var7)) continue;
            var4.add(var6);
        }
        return var4.isEmpty() ? null : (Map.Entry)var4.get(var1.getRandom().nextInt(var4.size()));
    }

    public static int getEnchantmentCost(RandomSource var0, int var1, int var2, ItemStack var3) {
        Item var4 = var3.getItem();
        int var5 = var4.getEnchantmentValue();
        if (var5 <= 0) {
            return 0;
        }
        if (var2 > 15) {
            var2 = 15;
        }
        int var6 = var0.nextInt(8) + 1 + (var2 >> 1) + var0.nextInt(var2 + 1);
        if (var1 == 0) {
            return Math.max(var6 / 3, 1);
        }
        if (var1 == 1) {
            return var6 * 2 / 3 + 1;
        }
        return Math.max(var6, var2 * 2);
    }

    public static ItemStack enchantItem(RandomSource var0, ItemStack var1, int var2, boolean var3) {
        List<WeightedRandomEnchant> var4 = EnchantmentManager.selectEnchantment(var0, var1, var2, var3);
        boolean var5 = var1.is(Items.BOOK);
        if (var5) {
            var1 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (WeightedRandomEnchant var7 : var4) {
            if (var5) {
                ItemEnchantedBook.addEnchantment(var1, var7);
                continue;
            }
            var1.enchant(var7.enchantment, var7.level);
        }
        return var1;
    }

    public static List<WeightedRandomEnchant> selectEnchantment(RandomSource var0, ItemStack var1, int var2, boolean var3) {
        ArrayList var4 = Lists.newArrayList();
        Item var5 = var1.getItem();
        int var6 = var5.getEnchantmentValue();
        if (var6 <= 0) {
            return var4;
        }
        var2 += 1 + var0.nextInt(var6 / 4 + 1) + var0.nextInt(var6 / 4 + 1);
        float var7 = (var0.nextFloat() + var0.nextFloat() - 1.0f) * 0.15f;
        List<WeightedRandomEnchant> var8 = EnchantmentManager.getAvailableEnchantmentResults(var2 = MathHelper.clamp(Math.round((float)var2 + (float)var2 * var7), 1, Integer.MAX_VALUE), var1, var3);
        if (!var8.isEmpty()) {
            WeightedRandom2.getRandomItem(var0, var8).ifPresent(var4::add);
            while (var0.nextInt(50) <= var2) {
                if (!var4.isEmpty()) {
                    EnchantmentManager.filterCompatibleEnchantments(var8, (WeightedRandomEnchant)SystemUtils.lastOf(var4));
                }
                if (var8.isEmpty()) break;
                WeightedRandom2.getRandomItem(var0, var8).ifPresent(var4::add);
                var2 /= 2;
            }
        }
        return var4;
    }

    public static void filterCompatibleEnchantments(List<WeightedRandomEnchant> var0, WeightedRandomEnchant var1) {
        Iterator<WeightedRandomEnchant> var2 = var0.iterator();
        while (var2.hasNext()) {
            if (var1.enchantment.isCompatibleWith(var2.next().enchantment)) continue;
            var2.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Enchantment> var0, Enchantment var1) {
        for (Enchantment var3 : var0) {
            if (var3.isCompatibleWith(var1)) continue;
            return false;
        }
        return true;
    }

    public static List<WeightedRandomEnchant> getAvailableEnchantmentResults(int var0, ItemStack var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        Item var4 = var1.getItem();
        boolean var5 = var1.is(Items.BOOK);
        block0: for (Enchantment var7 : BuiltInRegistries.ENCHANTMENT) {
            if (var7.isTreasureOnly() && !var2 || !var7.isDiscoverable() || !var7.category.canEnchant(var4) && !var5) continue;
            for (int var8 = var7.getMaxLevel(); var8 > var7.getMinLevel() - 1; --var8) {
                if (var0 < var7.getMinCost(var8) || var0 > var7.getMaxCost(var8)) continue;
                var3.add(new WeightedRandomEnchant(var7, var8));
                continue block0;
            }
        }
        return var3;
    }

    @FunctionalInterface
    static interface a {
        public void accept(Enchantment var1, int var2);
    }
}

