/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeTippedArrow
extends IRecipeComplex {
    public RecipeTippedArrow(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        if (var0.getWidth() != 3 || var0.getHeight() != 3) {
            return false;
        }
        for (int var2 = 0; var2 < var0.getWidth(); ++var2) {
            for (int var3 = 0; var3 < var0.getHeight(); ++var3) {
                ItemStack var4 = var0.getItem(var2 + var3 * var0.getWidth());
                if (var4.isEmpty()) {
                    return false;
                }
                if (!(var2 == 1 && var3 == 1 ? !var4.is(Items.LINGERING_POTION) : !var4.is(Items.ARROW))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var1 = var0.getItem(1 + var0.getWidth());
        if (!var1.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack var2 = new ItemStack(Items.TIPPED_ARROW, 8);
        PotionUtil.setPotion(var2, PotionUtil.getPotion(var1));
        PotionUtil.setCustomEffects(var2, PotionUtil.getCustomEffects(var1));
        return var2;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= 2 && var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.TIPPED_ARROW;
    }
}

