/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public class RecipeSuspiciousStew
extends IRecipeComplex {
    public RecipeSuspiciousStew(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        boolean var5 = false;
        for (int var6 = 0; var6 < var0.getContainerSize(); ++var6) {
            ItemStack var7 = var0.getItem(var6);
            if (var7.isEmpty()) continue;
            if (var7.is(Blocks.BROWN_MUSHROOM.asItem()) && !var4) {
                var4 = true;
                continue;
            }
            if (var7.is(Blocks.RED_MUSHROOM.asItem()) && !var3) {
                var3 = true;
                continue;
            }
            if (var7.is(TagsItem.SMALL_FLOWERS) && !var2) {
                var2 = true;
                continue;
            }
            if (var7.is(Items.BOWL) && !var5) {
                var5 = true;
                continue;
            }
            return false;
        }
        return var2 && var4 && var3 && var5;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var1 = new ItemStack(Items.SUSPICIOUS_STEW, 1);
        for (int var2 = 0; var2 < var0.getContainerSize(); ++var2) {
            SuspiciousEffectHolder var4;
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty() || (var4 = SuspiciousEffectHolder.tryGet(var3.getItem())) == null) continue;
            ItemSuspiciousStew.saveMobEffect(var1, var4.getSuspiciousEffect(), var4.getEffectDuration());
            break;
        }
        return var1;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= 2 && var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SUSPICIOUS_STEW;
    }
}

