/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;

public class RecipeShulkerBox
extends IRecipeComplex {
    public RecipeShulkerBox(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        int var2 = 0;
        int var3 = 0;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (Block.byItem(var5.getItem()) instanceof BlockShulkerBox) {
                ++var2;
            } else if (var5.getItem() instanceof ItemDye) {
                ++var3;
            } else {
                return false;
            }
            if (var3 <= 1 && var2 <= 1) continue;
            return false;
        }
        return var2 == 1 && var3 == 1;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var1 = ItemStack.EMPTY;
        ItemDye var2 = (ItemDye)Items.WHITE_DYE;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            Item var5 = var4.getItem();
            if (Block.byItem(var5) instanceof BlockShulkerBox) {
                var1 = var4;
                continue;
            }
            if (!(var5 instanceof ItemDye)) continue;
            var2 = (ItemDye)var5;
        }
        ItemStack var3 = BlockShulkerBox.getColoredItemStack(var2.getDyeColor());
        if (var1.hasTag()) {
            var3.setTag(var1.getTag().copy());
        }
        return var3;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHULKER_BOX_COLORING;
    }
}

