/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;

public class RecipeRepair
extends IRecipeComplex {
    public RecipeRepair(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        ArrayList var2 = Lists.newArrayList();
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var5;
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            var2.add(var4);
            if (var2.size() <= 1 || var4.is((var5 = (ItemStack)var2.get(0)).getItem()) && var5.getCount() == 1 && var4.getCount() == 1 && var5.getItem().canBeDepleted()) continue;
            return false;
        }
        return var2.size() == 2;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var2;
        Object var4;
        ItemStack var32;
        ArrayList var1 = Lists.newArrayList();
        for (int var22 = 0; var22 < var0.getContainerSize(); ++var22) {
            var32 = var0.getItem(var22);
            if (var32.isEmpty()) continue;
            var1.add(var32);
            if (var1.size() <= 1 || var32.is(((ItemStack)(var4 = (ItemStack)var1.get(0))).getItem()) && ((ItemStack)var4).getCount() == 1 && var32.getCount() == 1 && ((ItemStack)var4).getItem().canBeDepleted()) continue;
            return ItemStack.EMPTY;
        }
        if (var1.size() == 2 && (var2 = (ItemStack)var1.get(0)).is((var32 = (ItemStack)var1.get(1)).getItem()) && var2.getCount() == 1 && var32.getCount() == 1 && var2.getItem().canBeDepleted()) {
            var4 = var2.getItem();
            int var5 = ((Item)var4).getMaxDamage() - var2.getDamageValue();
            int var6 = ((Item)var4).getMaxDamage() - var32.getDamageValue();
            int var7 = var5 + var6 + ((Item)var4).getMaxDamage() * 5 / 100;
            int var8 = ((Item)var4).getMaxDamage() - var7;
            if (var8 < 0) {
                var8 = 0;
            }
            ItemStack var9 = new ItemStack(var2.getItem());
            var9.setDamageValue(var8);
            HashMap var10 = Maps.newHashMap();
            Map<Enchantment, Integer> var11 = EnchantmentManager.getEnchantments(var2);
            Map<Enchantment, Integer> var12 = EnchantmentManager.getEnchantments(var32);
            BuiltInRegistries.ENCHANTMENT.stream().filter(Enchantment::isCurse).forEach(var3 -> {
                int var4 = Math.max(var11.getOrDefault(var3, 0), var12.getOrDefault(var3, 0));
                if (var4 > 0) {
                    var10.put(var3, var4);
                }
            });
            if (!var10.isEmpty()) {
                EnchantmentManager.setEnchantments(var10, var9);
            }
            return var9;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

