/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack EMPTY = new RecipeItemStack(Stream.empty());
    private final Provider[] values;
    @Nullable
    public ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;

    public RecipeItemStack(Stream<? extends Provider> var0) {
        this.values = (Provider[])var0.toArray(Provider[]::new);
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(var0 -> var0.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack var0) {
        if (var0 == null) {
            return false;
        }
        if (this.isEmpty()) {
            return var0.isEmpty();
        }
        for (ItemStack var4 : this.getItems()) {
            if (!var4.is(var0.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] var0 = this.getItems();
            this.stackingIds = new IntArrayList(var0.length);
            for (ItemStack var4 : var0) {
                this.stackingIds.add(AutoRecipeStackManager.getStackingIndex(var4));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(PacketDataSerializer var0) {
        var0.writeCollection(Arrays.asList(this.getItems()), PacketDataSerializer::writeItem);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray var0 = new JsonArray();
        for (Provider var4 : this.values) {
            var0.add((JsonElement)var4.serialize());
        }
        return var0;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    private static RecipeItemStack fromValues(Stream<? extends Provider> var0) {
        RecipeItemStack var1 = new RecipeItemStack(var0);
        return var1.isEmpty() ? EMPTY : var1;
    }

    public static RecipeItemStack of() {
        return EMPTY;
    }

    public static RecipeItemStack of(IMaterial ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0).map(ItemStack::new));
    }

    public static RecipeItemStack of(ItemStack ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0));
    }

    public static RecipeItemStack of(Stream<ItemStack> var02) {
        return RecipeItemStack.fromValues(var02.filter(var0 -> !var0.isEmpty()).map(StackProvider::new));
    }

    public static RecipeItemStack of(TagKey<Item> var0) {
        return RecipeItemStack.fromValues(Stream.of(new b(var0)));
    }

    public static RecipeItemStack fromNetwork(PacketDataSerializer var0) {
        return RecipeItemStack.fromValues(var0.readList(PacketDataSerializer::readItem).stream().map(StackProvider::new));
    }

    public static RecipeItemStack fromJson(@Nullable JsonElement var02) {
        if (var02 == null || var02.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (var02.isJsonObject()) {
            return RecipeItemStack.fromValues(Stream.of(RecipeItemStack.valueFromJson(var02.getAsJsonObject())));
        }
        if (var02.isJsonArray()) {
            JsonArray var1 = var02.getAsJsonArray();
            if (var1.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return RecipeItemStack.fromValues(StreamSupport.stream(var1.spliterator(), false).map(var0 -> RecipeItemStack.valueFromJson(ChatDeserializer.convertToJsonObject(var0, "item"))));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static Provider valueFromJson(JsonObject var0) {
        if (var0.has("item") && var0.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (var0.has("item")) {
            Item var1 = ShapedRecipes.itemFromJson(var0);
            return new StackProvider(new ItemStack(var1));
        }
        if (var0.has("tag")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var0, "tag"));
            TagKey<Item> var2 = TagKey.create(Registries.ITEM, var1);
            return new b(var2);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    public static interface Provider {
        public Collection<ItemStack> getItems();

        public JsonObject serialize();
    }

    static class b
    implements Provider {
        private final TagKey<Item> tag;

        b(TagKey<Item> var0) {
            this.tag = var0;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList var0 = Lists.newArrayList();
            for (Holder<Item> var2 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                var0.add(new ItemStack(var2));
            }
            return var0;
        }

        @Override
        public JsonObject serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("tag", this.tag.location().toString());
            return var0;
        }
    }

    public static class StackProvider
    implements Provider {
        private final ItemStack item;

        public StackProvider(ItemStack var0) {
            this.item = var0;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }

        @Override
        public JsonObject serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("item", BuiltInRegistries.ITEM.getKey(this.item.getItem()).toString());
            return var0;
        }
    }
}

