/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworksFade
extends IRecipeComplex {
    private static final RecipeItemStack STAR_INGREDIENT = RecipeItemStack.of(Items.FIREWORK_STAR);

    public RecipeFireworksFade(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof ItemDye) {
                var2 = true;
                continue;
            }
            if (STAR_INGREDIENT.test(var5)) {
                if (var3) {
                    return false;
                }
                var3 = true;
                continue;
            }
            return false;
        }
        return var3 && var2;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ArrayList var1 = Lists.newArrayList();
        ItemStack var2 = null;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            Item var5 = var4.getItem();
            if (var5 instanceof ItemDye) {
                var1.add(((ItemDye)var5).getDyeColor().getFireworkColor());
                continue;
            }
            if (!STAR_INGREDIENT.test(var4)) continue;
            var2 = var4.copy();
            var2.setCount(1);
        }
        if (var2 == null || var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        var2.getOrCreateTagElement("Explosion").putIntArray("FadeColors", var1);
        return var2;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR_FADE;
    }
}

