/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworks
extends IRecipeComplex {
    private static final RecipeItemStack PAPER_INGREDIENT = RecipeItemStack.of(Items.PAPER);
    private static final RecipeItemStack GUNPOWDER_INGREDIENT = RecipeItemStack.of(Items.GUNPOWDER);
    private static final RecipeItemStack STAR_INGREDIENT = RecipeItemStack.of(Items.FIREWORK_STAR);

    public RecipeFireworks(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        int var3 = 0;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(var5)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(var5) ? ++var3 > 3 : !STAR_INGREDIENT.test(var5))) continue;
            return false;
        }
        return var2 && var3 >= 1;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var1 = new ItemStack(Items.FIREWORK_ROCKET, 3);
        NBTTagCompound var2 = var1.getOrCreateTagElement("Fireworks");
        NBTTagList var3 = new NBTTagList();
        int var4 = 0;
        for (int var5 = 0; var5 < var0.getContainerSize(); ++var5) {
            NBTTagCompound var7;
            ItemStack var6 = var0.getItem(var5);
            if (var6.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(var6)) {
                ++var4;
                continue;
            }
            if (!STAR_INGREDIENT.test(var6) || (var7 = var6.getTagElement("Explosion")) == null) continue;
            var3.add(var7);
        }
        var2.putByte("Flight", (byte)var4);
        if (!var3.isEmpty()) {
            var2.put("Explosions", var3);
        }
        return var1;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public ItemStack getResultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

