/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.IDyeable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeArmorDye
extends IRecipeComplex {
    public RecipeArmorDye(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        ItemStack var2 = ItemStack.EMPTY;
        ArrayList var3 = Lists.newArrayList();
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof IDyeable) {
                if (!var2.isEmpty()) {
                    return false;
                }
                var2 = var5;
                continue;
            }
            if (var5.getItem() instanceof ItemDye) {
                var3.add(var5);
                continue;
            }
            return false;
        }
        return !var2.isEmpty() && !var3.isEmpty();
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ArrayList var1 = Lists.newArrayList();
        ItemStack var2 = ItemStack.EMPTY;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            Item var5 = var4.getItem();
            if (var5 instanceof IDyeable) {
                if (!var2.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                var2 = var4.copy();
                continue;
            }
            if (var5 instanceof ItemDye) {
                var1.add((ItemDye)var5);
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (var2.isEmpty() || var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return IDyeable.dyeArmor(var2, var1);
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.ARMOR_DYE;
    }
}

