/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<Recipes<?>, Map<MinecraftKey, IRecipe<?>>> recipes = ImmutableMap.of();
    private Map<MinecraftKey, IRecipe<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public CraftingManager() {
        super(GSON, "recipes");
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var02, IResourceManager var1, GameProfilerFiller var2) {
        this.hasErrors = false;
        HashMap var3 = Maps.newHashMap();
        ImmutableMap.Builder var4 = ImmutableMap.builder();
        for (Map.Entry<MinecraftKey, JsonElement> var6 : var02.entrySet()) {
            MinecraftKey var7 = var6.getKey();
            try {
                IRecipe<?> var8 = CraftingManager.fromJson(var7, ChatDeserializer.convertToJsonObject(var6.getValue(), "top element"));
                var3.computeIfAbsent(var8.getType(), var0 -> ImmutableMap.builder()).put((Object)var7, var8);
                var4.put((Object)var7, var8);
            }
            catch (JsonParseException | IllegalArgumentException var8) {
                LOGGER.error("Parsing error loading recipe {}", (Object)var7, (Object)var8);
            }
        }
        this.recipes = (Map)var3.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((ImmutableMap.Builder)var0.getValue()).build()));
        this.byName = var4.build();
        LOGGER.info("Loaded {} recipes", (Object)var3.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> getRecipeFor(Recipes<T> var0, C var1, World var22) {
        return this.byType(var0).values().stream().filter(var2 -> var2.matches(var1, var22)).findFirst();
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<Pair<MinecraftKey, T>> getRecipeFor(Recipes<T> var02, C var1, World var22, @Nullable MinecraftKey var3) {
        IRecipe var5;
        Map<MinecraftKey, T> var4 = this.byType(var02);
        if (var3 != null && (var5 = (IRecipe)var4.get(var3)) != null && var5.matches(var1, var22)) {
            return Optional.of(Pair.of((Object)var3, (Object)var5));
        }
        return var4.entrySet().stream().filter(var2 -> ((IRecipe)var2.getValue()).matches(var1, var22)).findFirst().map(var0 -> Pair.of((Object)((MinecraftKey)var0.getKey()), (Object)((IRecipe)var0.getValue())));
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> getAllRecipesFor(Recipes<T> var0) {
        return List.copyOf(this.byType(var0).values());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> getRecipesFor(Recipes<T> var02, C var1, World var22) {
        return this.byType(var02).values().stream().filter(var2 -> var2.matches(var1, var22)).sorted(Comparator.comparing(var0 -> var0.getResultItem().getDescriptionId())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<MinecraftKey, T> byType(Recipes<T> var0) {
        return this.recipes.getOrDefault(var0, Collections.emptyMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> var0, C var1, World var2) {
        Optional<T> var3 = this.getRecipeFor(var0, var1, var2);
        if (var3.isPresent()) {
            return ((IRecipe)var3.get()).getRemainingItems(var1);
        }
        NonNullList<ItemStack> var4 = NonNullList.withSize(var1.getContainerSize(), ItemStack.EMPTY);
        for (int var5 = 0; var5 < var4.size(); ++var5) {
            var4.set(var5, var1.getItem(var5));
        }
        return var4;
    }

    public Optional<? extends IRecipe<?>> byKey(MinecraftKey var0) {
        return Optional.ofNullable(this.byName.get(var0));
    }

    public Collection<IRecipe<?>> getRecipes() {
        return this.recipes.values().stream().flatMap(var0 -> var0.values().stream()).collect(Collectors.toSet());
    }

    public Stream<MinecraftKey> getRecipeIds() {
        return this.recipes.values().stream().flatMap(var0 -> var0.keySet().stream());
    }

    public static IRecipe<?> fromJson(MinecraftKey var0, JsonObject var1) {
        String var2 = ChatDeserializer.getAsString(var1, "type");
        return BuiltInRegistries.RECIPE_SERIALIZER.getOptional(new MinecraftKey(var2)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + var2 + "'")).fromJson(var0, var1);
    }

    public void replaceRecipes(Iterable<IRecipe<?>> var0) {
        this.hasErrors = false;
        HashMap var1 = Maps.newHashMap();
        ImmutableMap.Builder var22 = ImmutableMap.builder();
        var0.forEach(var2 -> {
            Map var3 = var1.computeIfAbsent(var2.getType(), var0 -> Maps.newHashMap());
            MinecraftKey var4 = var2.getId();
            IRecipe var5 = var3.put(var4, var2);
            var22.put((Object)var4, var2);
            if (var5 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + var4);
            }
        });
        this.recipes = ImmutableMap.copyOf((Map)var1);
        this.byName = var22.build();
    }

    public static <C extends IInventory, T extends IRecipe<C>> a<C, T> createCheck(final Recipes<T> var0) {
        return new a<C, T>(){
            @Nullable
            private MinecraftKey lastRecipe;

            @Override
            public Optional<T> getRecipeFor(C var02, World var1) {
                CraftingManager var2 = var1.getRecipeManager();
                Optional var3 = var2.getRecipeFor(var0, var02, var1, this.lastRecipe);
                if (var3.isPresent()) {
                    Pair var4 = var3.get();
                    this.lastRecipe = (MinecraftKey)var4.getFirst();
                    return Optional.of((IRecipe)var4.getSecond());
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<C extends IInventory, T extends IRecipe<C>> {
        public Optional<T> getRecipeFor(C var1, World var2);
    }
}

