/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.level.World;

public class ItemSuspiciousStew
extends Item {
    public static final String EFFECTS_TAG = "Effects";
    public static final String EFFECT_ID_TAG = "EffectId";
    public static final String EFFECT_DURATION_TAG = "EffectDuration";
    public static final int DEFAULT_DURATION = 160;

    public ItemSuspiciousStew(Item.Info var0) {
        super(var0);
    }

    public static void saveMobEffect(ItemStack var0, MobEffectList var1, int var2) {
        NBTTagCompound var3 = var0.getOrCreateTag();
        NBTTagList var4 = var3.getList(EFFECTS_TAG, 9);
        NBTTagCompound var5 = new NBTTagCompound();
        var5.putInt(EFFECT_ID_TAG, MobEffectList.getId(var1));
        var5.putInt(EFFECT_DURATION_TAG, var2);
        var4.add(var5);
        var3.put(EFFECTS_TAG, var4);
    }

    private static void listPotionEffects(ItemStack var0, Consumer<MobEffect> var1) {
        NBTTagCompound var2 = var0.getTag();
        if (var2 != null && var2.contains(EFFECTS_TAG, 9)) {
            NBTTagList var3 = var2.getList(EFFECTS_TAG, 10);
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                NBTTagCompound var5 = var3.getCompound(var4);
                int var6 = var5.contains(EFFECT_DURATION_TAG, 3) ? var5.getInt(EFFECT_DURATION_TAG) : 160;
                MobEffectList var7 = MobEffectList.byId(var5.getInt(EFFECT_ID_TAG));
                if (var7 == null) continue;
                var1.accept(new MobEffect(var7, var6));
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        if (var3.isCreative()) {
            ArrayList<MobEffect> var4 = new ArrayList<MobEffect>();
            ItemSuspiciousStew.listPotionEffects(var0, var4::add);
            PotionUtil.addPotionTooltip(var4, var2, 1.0f);
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        ItemStack var3 = super.finishUsingItem(var0, var1, var2);
        ItemSuspiciousStew.listPotionEffects(var3, var2::addEffect);
        if (var2 instanceof EntityHuman && ((EntityHuman)var2).getAbilities().instabuild) {
            return var3;
        }
        return new ItemStack(Items.BOWL);
    }
}

