/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;

public interface RecipeHolder {
    public void setRecipeUsed(@Nullable IRecipe<?> var1);

    @Nullable
    public IRecipe<?> getRecipeUsed();

    default public void awardUsedRecipes(EntityHuman var0) {
        IRecipe<?> var1 = this.getRecipeUsed();
        if (var1 != null && !var1.isSpecial()) {
            var0.awardRecipes(Collections.singleton(var1));
            this.setRecipeUsed(null);
        }
    }

    default public boolean setRecipeUsed(World var0, EntityPlayer var1, IRecipe<?> var2) {
        if (var2.isSpecial() || !var0.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || var1.getRecipeBook().contains(var2)) {
            this.setRecipeUsed(var2);
            return true;
        }
        return false;
    }
}

