/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;

public class ContainerBrewingStand
extends Container {
    private static final int BOTTLE_SLOT_START = 0;
    private static final int BOTTLE_SLOT_END = 2;
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int SLOT_COUNT = 5;
    private static final int DATA_COUNT = 2;
    private static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    private final IInventory brewingStand;
    private final IContainerProperties brewingStandData;
    private final Slot ingredientSlot;

    public ContainerBrewingStand(int var0, PlayerInventory var1) {
        this(var0, var1, new InventorySubcontainer(5), new ContainerProperties(2));
    }

    public ContainerBrewingStand(int var0, PlayerInventory var1, IInventory var2, IContainerProperties var3) {
        super(Containers.BREWING_STAND, var0);
        int var4;
        ContainerBrewingStand.checkContainerSize(var2, 5);
        ContainerBrewingStand.checkContainerDataCount(var3, 2);
        this.brewingStand = var2;
        this.brewingStandData = var3;
        this.addSlot(new SlotPotionBottle(var2, 0, 56, 51));
        this.addSlot(new SlotPotionBottle(var2, 1, 79, 58));
        this.addSlot(new SlotPotionBottle(var2, 2, 102, 51));
        this.ingredientSlot = this.addSlot(new SlotBrewing(var2, 3, 79, 17));
        this.addSlot(new a(var2, 4, 17, 17));
        this.addDataSlots(var3);
        for (var4 = 0; var4 < 3; ++var4) {
            for (int var5 = 0; var5 < 9; ++var5) {
                this.addSlot(new Slot(var1, var5 + var4 * 9 + 9, 8 + var5 * 18, 84 + var4 * 18));
            }
        }
        for (var4 = 0; var4 < 9; ++var4) {
            this.addSlot(new Slot(var1, var4, 8 + var4 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.brewingStand.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 >= 0 && var1 <= 2 || var1 == 3 || var1 == 4) {
                if (!this.moveItemStackTo(var4, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (a.mayPlaceItem(var2) ? this.moveItemStackTo(var4, 4, 5, false) || this.ingredientSlot.mayPlace(var4) && !this.moveItemStackTo(var4, 3, 4, false) : (this.ingredientSlot.mayPlace(var4) ? !this.moveItemStackTo(var4, 3, 4, false) : (SlotPotionBottle.mayPlaceItem(var2) && var2.getCount() == 1 ? !this.moveItemStackTo(var4, 0, 3, false) : (var1 >= 5 && var1 < 32 ? !this.moveItemStackTo(var4, 32, 41, false) : (var1 >= 32 && var1 < 41 ? !this.moveItemStackTo(var4, 5, 32, false) : !this.moveItemStackTo(var4, 5, 41, false)))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.set(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    public int getFuel() {
        return this.brewingStandData.get(1);
    }

    public int getBrewingTicks() {
        return this.brewingStandData.get(0);
    }

    static class SlotPotionBottle
    extends Slot {
        public SlotPotionBottle(IInventory var0, int var1, int var2, int var3) {
            super(var0, var1, var2, var3);
        }

        @Override
        public boolean mayPlace(ItemStack var0) {
            return SlotPotionBottle.mayPlaceItem(var0);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void onTake(EntityHuman var0, ItemStack var1) {
            PotionRegistry var2 = PotionUtil.getPotion(var1);
            if (var0 instanceof EntityPlayer) {
                CriterionTriggers.BREWED_POTION.trigger((EntityPlayer)var0, var2);
            }
            super.onTake(var0, var1);
        }

        public static boolean mayPlaceItem(ItemStack var0) {
            return var0.is(Items.POTION) || var0.is(Items.SPLASH_POTION) || var0.is(Items.LINGERING_POTION) || var0.is(Items.GLASS_BOTTLE);
        }
    }

    static class SlotBrewing
    extends Slot {
        public SlotBrewing(IInventory var0, int var1, int var2, int var3) {
            super(var0, var1, var2, var3);
        }

        @Override
        public boolean mayPlace(ItemStack var0) {
            return PotionBrewer.isIngredient(var0);
        }

        @Override
        public int getMaxStackSize() {
            return 64;
        }
    }

    static class a
    extends Slot {
        public a(IInventory var0, int var1, int var2, int var3) {
            super(var0, var1, var2, var3);
        }

        @Override
        public boolean mayPlace(ItemStack var0) {
            return a.mayPlaceItem(var0);
        }

        public static boolean mayPlaceItem(ItemStack var0) {
            return var0.is(Items.BLAZE_POWDER);
        }

        @Override
        public int getMaxStackSize() {
            return 64;
        }
    }
}

