/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntitySmallFireball
extends EntityFireballFireball {
    public EntitySmallFireball(EntityTypes<? extends EntitySmallFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireballFireball>)var0, var1);
    }

    public EntitySmallFireball(World var0, EntityLiving var1, double var2, double var4, double var6) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.SMALL_FIREBALL, var1, var2, var4, var6, var0);
    }

    public EntitySmallFireball(World var0, double var1, double var3, double var5, double var7, double var9, double var11) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.SMALL_FIREBALL, var1, var3, var5, var7, var9, var11, var0);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        if (this.level.isClientSide) {
            return;
        }
        Entity var1 = var0.getEntity();
        Entity var2 = this.getOwner();
        int var3 = var1.getRemainingFireTicks();
        var1.setSecondsOnFire(5);
        if (!var1.hurt(DamageSource.fireball(this, var2), 5.0f)) {
            var1.setRemainingFireTicks(var3);
        } else if (var2 instanceof EntityLiving) {
            this.doEnchantDamageEffects((EntityLiving)var2, var1);
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        BlockPosition var2;
        super.onHitBlock(var0);
        if (this.level.isClientSide) {
            return;
        }
        Entity var1 = this.getOwner();
        if ((!(var1 instanceof EntityInsentient) || this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && this.level.isEmptyBlock(var2 = var0.getBlockPos().relative(var0.getDirection()))) {
            this.level.setBlockAndUpdate(var2, BlockFireAbstract.getState(this.level, var2));
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level.isClientSide) {
            this.discard();
        }
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        return false;
    }
}

