/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;

public abstract class EntityProjectileThrowable
extends EntityProjectile
implements ItemSupplier {
    private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK = DataWatcher.defineId(EntityProjectileThrowable.class, DataWatcherRegistry.ITEM_STACK);

    public EntityProjectileThrowable(EntityTypes<? extends EntityProjectileThrowable> var0, World var1) {
        super((EntityTypes<? extends EntityProjectile>)var0, var1);
    }

    public EntityProjectileThrowable(EntityTypes<? extends EntityProjectileThrowable> var0, double var1, double var3, double var5, World var7) {
        super(var0, var1, var3, var5, var7);
    }

    public EntityProjectileThrowable(EntityTypes<? extends EntityProjectileThrowable> var0, EntityLiving var1, World var2) {
        super(var0, var1, var2);
    }

    public void setItem(ItemStack var02) {
        if (!var02.is(this.getDefaultItem()) || var02.hasTag()) {
            this.getEntityData().set(DATA_ITEM_STACK, SystemUtils.make(var02.copy(), var0 -> var0.setCount(1)));
        }
    }

    protected abstract Item getDefaultItem();

    public ItemStack getItemRaw() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    public ItemStack getItem() {
        ItemStack var0 = this.getItemRaw();
        return var0.isEmpty() ? new ItemStack(this.getDefaultItem()) : var0;
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_ITEM_STACK, ItemStack.EMPTY);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        ItemStack var1 = this.getItemRaw();
        if (!var1.isEmpty()) {
            var0.put("Item", var1.save(new NBTTagCompound()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        ItemStack var1 = ItemStack.of(var0.getCompound("Item"));
        this.setItem(var1);
    }
}

