/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityLargeFireball
extends EntityFireballFireball {
    public int explosionPower = 1;

    public EntityLargeFireball(EntityTypes<? extends EntityLargeFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireballFireball>)var0, var1);
    }

    public EntityLargeFireball(World var0, EntityLiving var1, double var2, double var4, double var6, int var8) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.FIREBALL, var1, var2, var4, var6, var0);
        this.explosionPower = var8;
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level.isClientSide) {
            boolean var1 = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            this.level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.explosionPower, var1, World.a.MOB);
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        if (this.level.isClientSide) {
            return;
        }
        Entity var1 = var0.getEntity();
        Entity var2 = this.getOwner();
        var1.hurt(DamageSource.fireball(this, var2), 6.0f);
        if (var2 instanceof EntityLiving) {
            this.doEnchantDamageEffects((EntityLiving)var2, var1);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("ExplosionPower", 99)) {
            this.explosionPower = var0.getByte("ExplosionPower");
        }
    }
}

