/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityEnderPearl
extends EntityProjectileThrowable {
    public EntityEnderPearl(EntityTypes<? extends EntityEnderPearl> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityEnderPearl(World var0, EntityLiving var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.ENDER_PEARL, var1, var0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        var0.getEntity().hurt(DamageSource.thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        for (int var1 = 0; var1 < 32; ++var1) {
            this.level.addParticle(Particles.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        if (!this.level.isClientSide && !this.isRemoved()) {
            Entity var1 = this.getOwner();
            if (var1 instanceof EntityPlayer) {
                EntityPlayer var2 = (EntityPlayer)var1;
                if (var2.connection.getConnection().isConnected() && var2.level == this.level && !var2.isSleeping()) {
                    EntityEndermite var3;
                    if (this.random.nextFloat() < 0.05f && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (var3 = EntityTypes.ENDERMITE.create(this.level)) != null) {
                        var3.moveTo(var1.getX(), var1.getY(), var1.getZ(), var1.getYRot(), var1.getXRot());
                        this.level.addFreshEntity(var3);
                    }
                    if (var1.isPassenger()) {
                        var2.dismountTo(this.getX(), this.getY(), this.getZ());
                    } else {
                        var1.teleportTo(this.getX(), this.getY(), this.getZ());
                    }
                    var1.resetFallDistance();
                    var1.hurt(DamageSource.FALL, 5.0f);
                }
            } else if (var1 != null) {
                var1.teleportTo(this.getX(), this.getY(), this.getZ());
                var1.resetFallDistance();
            }
            this.discard();
        }
    }

    @Override
    public void tick() {
        Entity var0 = this.getOwner();
        if (var0 instanceof EntityHuman && !var0.isAlive()) {
            this.discard();
        } else {
            super.tick();
        }
    }

    @Override
    @Nullable
    public Entity changeDimension(WorldServer var0) {
        Entity var1 = this.getOwner();
        if (var1 != null && var1.level.dimension() != var0.dimension()) {
            this.setOwner(null);
        }
        return super.changeDimension(var0);
    }
}

