/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;

public class AutoRecipeStackManager {
    private static final int EMPTY = 0;
    public final Int2IntMap contents = new Int2IntOpenHashMap();

    public void accountSimpleStack(ItemStack var0) {
        if (!(var0.isDamaged() || var0.isEnchanted() || var0.hasCustomHoverName())) {
            this.accountStack(var0);
        }
    }

    public void accountStack(ItemStack var0) {
        this.accountStack(var0, 64);
    }

    public void accountStack(ItemStack var0, int var1) {
        if (!var0.isEmpty()) {
            int var2 = AutoRecipeStackManager.getStackingIndex(var0);
            int var3 = Math.min(var1, var0.getCount());
            this.put(var2, var3);
        }
    }

    public static int getStackingIndex(ItemStack var0) {
        return BuiltInRegistries.ITEM.getId(var0.getItem());
    }

    boolean has(int var0) {
        return this.contents.get(var0) > 0;
    }

    int take(int var0, int var1) {
        int var2 = this.contents.get(var0);
        if (var2 >= var1) {
            this.contents.put(var0, var2 - var1);
            return var0;
        }
        return 0;
    }

    void put(int var0, int var1) {
        this.contents.put(var0, this.contents.get(var0) + var1);
    }

    public boolean canCraft(IRecipe<?> var0, @Nullable IntList var1) {
        return this.canCraft(var0, var1, 1);
    }

    public boolean canCraft(IRecipe<?> var0, @Nullable IntList var1, int var2) {
        return new a(var0).tryPick(var2, var1);
    }

    public int getBiggestCraftableStack(IRecipe<?> var0, @Nullable IntList var1) {
        return this.getBiggestCraftableStack(var0, Integer.MAX_VALUE, var1);
    }

    public int getBiggestCraftableStack(IRecipe<?> var0, int var1, @Nullable IntList var2) {
        return new a(var0).tryPickAll(var1, var2);
    }

    public static ItemStack fromStackingIndex(int var0) {
        if (var0 == 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack(Item.byId(var0));
    }

    public void clear() {
        this.contents.clear();
    }

    class a {
        private final IRecipe<?> recipe;
        private final List<RecipeItemStack> ingredients = Lists.newArrayList();
        private final int ingredientCount;
        private final int[] items;
        private final int itemCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public a(IRecipe var1) {
            this.recipe = var1;
            this.ingredients.addAll(var1.getIngredients());
            this.ingredients.removeIf(RecipeItemStack::isEmpty);
            this.ingredientCount = this.ingredients.size();
            this.items = this.getUniqueAvailableIngredientItems();
            this.itemCount = this.items.length;
            this.data = new BitSet(this.ingredientCount + this.itemCount + this.ingredientCount + this.ingredientCount * this.itemCount);
            for (int var2 = 0; var2 < this.ingredients.size(); ++var2) {
                IntList var3 = this.ingredients.get(var2).getStackingIds();
                for (int var4 = 0; var4 < this.itemCount; ++var4) {
                    if (!var3.contains(this.items[var4])) continue;
                    this.data.set(this.getIndex(true, var4, var2));
                }
            }
        }

        public boolean tryPick(int var0, @Nullable IntList var1) {
            int var4;
            int var3;
            if (var0 <= 0) {
                return true;
            }
            int var2 = 0;
            while (this.dfs(var0)) {
                AutoRecipeStackManager.this.take(this.items[this.path.getInt(0)], var0);
                var3 = this.path.size() - 1;
                this.setSatisfied(this.path.getInt(var3));
                for (var4 = 0; var4 < var3; ++var4) {
                    this.toggleResidual((var4 & 1) == 0, this.path.get(var4), this.path.get(var4 + 1));
                }
                this.path.clear();
                this.data.clear(0, this.ingredientCount + this.itemCount);
                ++var2;
            }
            var3 = var2 == this.ingredientCount ? 1 : 0;
            int n2 = var4 = var3 != 0 && var1 != null ? 1 : 0;
            if (var4 != 0) {
                var1.clear();
            }
            this.data.clear(0, this.ingredientCount + this.itemCount + this.ingredientCount);
            int var5 = 0;
            NonNullList<RecipeItemStack> var6 = this.recipe.getIngredients();
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                if (var4 != 0 && ((RecipeItemStack)var6.get(var7)).isEmpty()) {
                    var1.add(0);
                    continue;
                }
                for (int var8 = 0; var8 < this.itemCount; ++var8) {
                    if (!this.hasResidual(false, var5, var8)) continue;
                    this.toggleResidual(true, var8, var5);
                    AutoRecipeStackManager.this.put(this.items[var8], var0);
                    if (var4 == 0) continue;
                    var1.add(this.items[var8]);
                }
                ++var5;
            }
            return var3 != 0;
        }

        private int[] getUniqueAvailableIngredientItems() {
            IntAVLTreeSet var0 = new IntAVLTreeSet();
            for (RecipeItemStack var2 : this.ingredients) {
                var0.addAll((IntCollection)var2.getStackingIds());
            }
            IntIterator var1 = var0.iterator();
            while (var1.hasNext()) {
                if (AutoRecipeStackManager.this.has(var1.nextInt())) continue;
                var1.remove();
            }
            return var0.toIntArray();
        }

        private boolean dfs(int var0) {
            int var1 = this.itemCount;
            for (int var2 = 0; var2 < var1; ++var2) {
                if (AutoRecipeStackManager.this.contents.get(this.items[var2]) < var0) continue;
                this.visit(false, var2);
                while (!this.path.isEmpty()) {
                    int var7;
                    int var3 = this.path.size();
                    boolean var4 = (var3 & 1) == 1;
                    int var5 = this.path.getInt(var3 - 1);
                    if (!var4 && !this.isSatisfied(var5)) break;
                    int var6 = var4 ? this.ingredientCount : var1;
                    for (var7 = 0; var7 < var6; ++var7) {
                        if (this.hasVisited(var4, var7) || !this.hasConnection(var4, var5, var7) || !this.hasResidual(var4, var5, var7)) continue;
                        this.visit(var4, var7);
                        break;
                    }
                    if ((var7 = this.path.size()) != var3) continue;
                    this.path.removeInt(var7 - 1);
                }
                if (this.path.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean isSatisfied(int var0) {
            return this.data.get(this.getSatisfiedIndex(var0));
        }

        private void setSatisfied(int var0) {
            this.data.set(this.getSatisfiedIndex(var0));
        }

        private int getSatisfiedIndex(int var0) {
            return this.ingredientCount + this.itemCount + var0;
        }

        private boolean hasConnection(boolean var0, int var1, int var2) {
            return this.data.get(this.getIndex(var0, var1, var2));
        }

        private boolean hasResidual(boolean var0, int var1, int var2) {
            return var0 != this.data.get(1 + this.getIndex(var0, var1, var2));
        }

        private void toggleResidual(boolean var0, int var1, int var2) {
            this.data.flip(1 + this.getIndex(var0, var1, var2));
        }

        private int getIndex(boolean var0, int var1, int var2) {
            int var3 = var0 ? var1 * this.ingredientCount + var2 : var2 * this.ingredientCount + var1;
            return this.ingredientCount + this.itemCount + this.ingredientCount + 2 * var3;
        }

        private void visit(boolean var0, int var1) {
            this.data.set(this.getVisitedIndex(var0, var1));
            this.path.add(var1);
        }

        private boolean hasVisited(boolean var0, int var1) {
            return this.data.get(this.getVisitedIndex(var0, var1));
        }

        private int getVisitedIndex(boolean var0, int var1) {
            return (var0 ? 0 : this.ingredientCount) + var1;
        }

        public int tryPickAll(int var0, @Nullable IntList var1) {
            int var4;
            int var2 = 0;
            int var3 = Math.min(var0, this.getMinIngredientCount()) + 1;
            while (true) {
                if (this.tryPick(var4 = (var2 + var3) / 2, null)) {
                    if (var3 - var2 <= 1) break;
                    var2 = var4;
                    continue;
                }
                var3 = var4;
            }
            if (var4 > 0) {
                this.tryPick(var4, var1);
            }
            return var4;
        }

        private int getMinIngredientCount() {
            int var0 = Integer.MAX_VALUE;
            for (RecipeItemStack var2 : this.ingredients) {
                int var3 = 0;
                IntListIterator intListIterator = var2.getStackingIds().iterator();
                while (intListIterator.hasNext()) {
                    int var5 = (Integer)intListIterator.next();
                    var3 = Math.max(var3, AutoRecipeStackManager.this.contents.get(var5));
                }
                if (var0 <= 0) continue;
                var0 = Math.min(var0, var3);
            }
            return var0;
        }
    }
}

