/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityVindicator
extends EntityIllagerAbstract {
    private static final String TAG_JOHNNY = "Johnny";
    static final Predicate<EnumDifficulty> DOOR_BREAKING_PREDICATE = var0 -> var0 == EnumDifficulty.NORMAL || var0 == EnumDifficulty.HARD;
    public boolean isJohnny;

    public EntityVindicator(EntityTypes<? extends EntityVindicator> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerAbstract>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new a(this));
        this.goalSelector.addGoal(2, new EntityIllagerAbstract.b(this, this));
        this.goalSelector.addGoal(3, new EntityRaider.a(this, 10.0f));
        this.goalSelector.addGoal(4, new c(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(4, new b(this));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    protected void customServerAiStep() {
        if (!this.isNoAi() && PathfinderGoalUtil.hasGroundPathNavigation(this)) {
            boolean var0 = ((WorldServer)this.level).isRaided(this.blockPosition());
            ((Navigation)this.getNavigation()).setCanOpenDoors(var0);
        }
        super.customServerAiStep();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.35f).add(GenericAttributes.FOLLOW_RANGE, 12.0).add(GenericAttributes.MAX_HEALTH, 24.0).add(GenericAttributes.ATTACK_DAMAGE, 5.0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.isJohnny) {
            var0.putBoolean(TAG_JOHNNY, true);
        }
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        if (this.isAggressive()) {
            return EntityIllagerAbstract.a.ATTACKING;
        }
        if (this.isCelebrating()) {
            return EntityIllagerAbstract.a.CELEBRATING;
        }
        return EntityIllagerAbstract.a.CROSSED;
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains(TAG_JOHNNY, 99)) {
            this.isJohnny = var0.getBoolean(TAG_JOHNNY);
        }
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.VINDICATOR_CELEBRATE;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        GroupDataEntity var5 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        ((Navigation)this.getNavigation()).setCanOpenDoors(true);
        RandomSource var6 = var0.getRandom();
        this.populateDefaultEquipmentSlots(var6, var1);
        this.populateDefaultEquipmentEnchantments(var6, var1);
        return var5;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (this.getCurrentRaid() == null) {
            this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_AXE));
        }
    }

    @Override
    public boolean isAlliedTo(Entity var0) {
        if (super.isAlliedTo(var0)) {
            return true;
        }
        if (var0 instanceof EntityLiving && ((EntityLiving)var0).getMobType() == EnumMonsterType.ILLAGER) {
            return this.getTeam() == null && var0.getTeam() == null;
        }
        return false;
    }

    @Override
    public void setCustomName(@Nullable IChatBaseComponent var0) {
        super.setCustomName(var0);
        if (!this.isJohnny && var0 != null && var0.getString().equals(TAG_JOHNNY)) {
            this.isJohnny = true;
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.VINDICATOR_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.VINDICATOR_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.VINDICATOR_HURT;
    }

    @Override
    public void applyRaidBuffs(int var0, boolean var1) {
        boolean var5;
        ItemStack var2 = new ItemStack(Items.IRON_AXE);
        Raid var3 = this.getCurrentRaid();
        int var4 = 1;
        if (var0 > var3.getNumGroups(EnumDifficulty.NORMAL)) {
            var4 = 2;
        }
        boolean bl = var5 = this.random.nextFloat() <= var3.getEnchantOdds();
        if (var5) {
            HashMap var6 = Maps.newHashMap();
            var6.put(Enchantments.SHARPNESS, var4);
            EnchantmentManager.setEnchantments(var6, var2);
        }
        this.setItemSlot(EnumItemSlot.MAINHAND, var2);
    }

    static class a
    extends PathfinderGoalBreakDoor {
        public a(EntityInsentient var0) {
            super(var0, 6, DOOR_BREAKING_PREDICATE);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canContinueToUse() {
            EntityVindicator var0 = (EntityVindicator)this.mob;
            return var0.hasActiveRaid() && super.canContinueToUse();
        }

        @Override
        public boolean canUse() {
            EntityVindicator var0 = (EntityVindicator)this.mob;
            return var0.hasActiveRaid() && var0.random.nextInt(a.reducedTickDelay(10)) == 0 && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            this.mob.setNoActionTime(0);
        }
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c(EntityVindicator var1) {
            super(var1, 1.0, false);
        }

        @Override
        protected double getAttackReachSqr(EntityLiving var0) {
            if (this.mob.getVehicle() instanceof EntityRavager) {
                float var1 = this.mob.getVehicle().getBbWidth() - 0.1f;
                return var1 * 2.0f * (var1 * 2.0f) + var0.getBbWidth();
            }
            return super.getAttackReachSqr(var0);
        }
    }

    static class b
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public b(EntityVindicator var0) {
            super(var0, EntityLiving.class, 0, true, true, EntityLiving::attackable);
        }

        @Override
        public boolean canUse() {
            return ((EntityVindicator)this.mob).isJohnny && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            this.mob.setNoActionTime(0);
        }
    }
}

