/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers friendsGoal;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.friendsGoal = new PathfinderGoalSilverfishWakeOthers(this);
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new ClimbOnTopOfPowderSnowGoal(this, this.level));
        this.goalSelector.addGoal(3, this.friendsGoal);
        this.goalSelector.addGoal(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.goalSelector.addGoal(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    @Override
    public double getMyRidingOffset() {
        return 0.1;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.13f;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 8.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25).add(GenericAttributes.ATTACK_DAMAGE, 1.0);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SILVERFISH_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SILVERFISH_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SILVERFISH_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SILVERFISH_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if ((var0 instanceof EntityDamageSource || var0 == DamageSource.MAGIC) && this.friendsGoal != null) {
            this.friendsGoal.notifyHurt();
        }
        return super.hurt(var0, var1);
    }

    @Override
    public void tick() {
        this.yBodyRot = this.getYRot();
        super.tick();
    }

    @Override
    public void setYBodyRot(float var0) {
        this.setYRot(var0);
        super.setYBodyRot(var0);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (BlockMonsterEggs.isCompatibleHostBlock(var1.getBlockState(var0.below()))) {
            return 10.0f;
        }
        return super.getWalkTargetValue(var0, var1);
    }

    public static boolean checkSilverfishSpawnRules(EntityTypes<EntitySilverfish> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        if (EntitySilverfish.checkAnyLightMonsterSpawnRules(var0, var1, var2, var3, var4)) {
            EntityHuman var5 = var1.getNearestPlayer((double)var3.getX() + 0.5, (double)var3.getY() + 0.5, (double)var3.getZ() + 0.5, 5.0, true);
            return var5 == null;
        }
        return false;
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.ARTHROPOD;
    }

    static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish silverfish;
        private int lookForFriends;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish var0) {
            this.silverfish = var0;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = this.adjustedTickDelay(20);
            }
        }

        @Override
        public boolean canUse() {
            return this.lookForFriends > 0;
        }

        @Override
        public void tick() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                World var0 = this.silverfish.level;
                RandomSource var1 = this.silverfish.getRandom();
                BlockPosition var2 = this.silverfish.blockPosition();
                int var3 = 0;
                block0: while (var3 <= 5 && var3 >= -5) {
                    int var4 = 0;
                    while (var4 <= 10 && var4 >= -10) {
                        int var5 = 0;
                        while (var5 <= 10 && var5 >= -10) {
                            BlockPosition var6 = var2.offset(var4, var3, var5);
                            IBlockData var7 = var0.getBlockState(var6);
                            Block var8 = var7.getBlock();
                            if (var8 instanceof BlockMonsterEggs) {
                                if (var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                                    var0.destroyBlock(var6, true, this.silverfish);
                                } else {
                                    var0.setBlock(var6, ((BlockMonsterEggs)var8).hostStateByInfested(var0.getBlockState(var6)), 3);
                                }
                                if (var1.nextBoolean()) break block0;
                            }
                            var5 = (var5 <= 0 ? 1 : 0) - var5;
                        }
                        var4 = (var4 <= 0 ? 1 : 0) - var4;
                    }
                    var3 = (var3 <= 0 ? 1 : 0) - var3;
                }
            }
        }
    }

    static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection selectedDirection;
        private boolean doMerge;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish var0) {
            super(var0, 1.0, 10);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (this.mob.getTarget() != null) {
                return false;
            }
            if (!this.mob.getNavigation().isDone()) {
                return false;
            }
            RandomSource var0 = this.mob.getRandom();
            if (this.mob.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && var0.nextInt(PathfinderGoalSilverfishHideInBlock.reducedTickDelay(10)) == 0) {
                this.selectedDirection = EnumDirection.getRandom(var0);
                BlockPosition var1 = new BlockPosition(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ()).relative(this.selectedDirection);
                IBlockData var2 = this.mob.level.getBlockState(var1);
                if (BlockMonsterEggs.isCompatibleHostBlock(var2)) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            if (this.doMerge) {
                return false;
            }
            return super.canContinueToUse();
        }

        @Override
        public void start() {
            if (!this.doMerge) {
                super.start();
                return;
            }
            World var0 = this.mob.level;
            BlockPosition var1 = new BlockPosition(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ()).relative(this.selectedDirection);
            IBlockData var2 = var0.getBlockState(var1);
            if (BlockMonsterEggs.isCompatibleHostBlock(var2)) {
                var0.setBlock(var1, BlockMonsterEggs.infestedStateByHost(var2), 3);
                this.mob.spawnAnim();
                this.mob.discard();
            }
        }
    }
}

