/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityMonsterPatrolling
extends EntityMonster {
    @Nullable
    private BlockPosition patrolTarget;
    private boolean patrolLeader;
    private boolean patrolling;

    protected EntityMonsterPatrolling(EntityTypes<? extends EntityMonsterPatrolling> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, new a<EntityMonsterPatrolling>(this, 0.7, 0.595));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.patrolTarget != null) {
            var0.put("PatrolTarget", GameProfileSerializer.writeBlockPos(this.patrolTarget));
        }
        var0.putBoolean("PatrolLeader", this.patrolLeader);
        var0.putBoolean("Patrolling", this.patrolling);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("PatrolTarget")) {
            this.patrolTarget = GameProfileSerializer.readBlockPos(var0.getCompound("PatrolTarget"));
        }
        this.patrolLeader = var0.getBoolean("PatrolLeader");
        this.patrolling = var0.getBoolean("Patrolling");
    }

    @Override
    public double getMyRidingOffset() {
        return -0.45;
    }

    public boolean canBeLeader() {
        return true;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        if (var2 != EnumMobSpawn.PATROL && var2 != EnumMobSpawn.EVENT && var2 != EnumMobSpawn.STRUCTURE && var0.getRandom().nextFloat() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (this.isPatrolLeader()) {
            this.setItemSlot(EnumItemSlot.HEAD, Raid.getLeaderBannerInstance());
            this.setDropChance(EnumItemSlot.HEAD, 2.0f);
        }
        if (var2 == EnumMobSpawn.PATROL) {
            this.patrolling = true;
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    public static boolean checkPatrollingMonsterSpawnRules(EntityTypes<? extends EntityMonsterPatrolling> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        if (var1.getBrightness(EnumSkyBlock.BLOCK, var3) > 8) {
            return false;
        }
        return EntityMonsterPatrolling.checkAnyLightMonsterSpawnRules(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.patrolling || var0 > 16384.0;
    }

    public void setPatrolTarget(BlockPosition var0) {
        this.patrolTarget = var0;
        this.patrolling = true;
    }

    public BlockPosition getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean var0) {
        this.patrolLeader = var0;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolTarget = this.blockPosition().offset(-500 + this.random.nextInt(1000), 0, -500 + this.random.nextInt(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean var0) {
        this.patrolling = var0;
    }

    public static class a<T extends EntityMonsterPatrolling>
    extends PathfinderGoal {
        private static final int NAVIGATION_FAILED_COOLDOWN = 200;
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil;

        public a(T var0, double var1, double var3) {
            this.mob = var0;
            this.speedModifier = var1;
            this.leaderSpeedModifier = var3;
            this.cooldownUntil = -1L;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            boolean var0 = ((EntityMonsterPatrolling)this.mob).level.getGameTime() < this.cooldownUntil;
            return ((EntityMonsterPatrolling)this.mob).isPatrolling() && ((EntityInsentient)this.mob).getTarget() == null && !((Entity)this.mob).isVehicle() && ((EntityMonsterPatrolling)this.mob).hasPatrolTarget() && !var0;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void tick() {
            boolean var0 = ((EntityMonsterPatrolling)this.mob).isPatrolLeader();
            NavigationAbstract var1 = ((EntityInsentient)this.mob).getNavigation();
            if (var1.isDone()) {
                List<EntityMonsterPatrolling> var2 = this.findPatrolCompanions();
                if (((EntityMonsterPatrolling)this.mob).isPatrolling() && var2.isEmpty()) {
                    ((EntityMonsterPatrolling)this.mob).setPatrolling(false);
                } else if (!var0 || !((EntityMonsterPatrolling)this.mob).getPatrolTarget().closerToCenterThan(((Entity)this.mob).position(), 10.0)) {
                    Vec3D var3 = Vec3D.atBottomCenterOf(((EntityMonsterPatrolling)this.mob).getPatrolTarget());
                    Vec3D var4 = ((Entity)this.mob).position();
                    Vec3D var5 = var4.subtract(var3);
                    var3 = var5.yRot(90.0f).scale(0.4).add(var3);
                    Vec3D var6 = var3.subtract(var4).normalize().scale(10.0).add(var4);
                    BlockPosition var7 = new BlockPosition(var6);
                    if (!var1.moveTo((var7 = ((EntityMonsterPatrolling)this.mob).level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var7)).getX(), var7.getY(), var7.getZ(), var0 ? this.leaderSpeedModifier : this.speedModifier)) {
                        this.moveRandomly();
                        this.cooldownUntil = ((EntityMonsterPatrolling)this.mob).level.getGameTime() + 200L;
                    } else if (var0) {
                        for (EntityMonsterPatrolling var9 : var2) {
                            var9.setPatrolTarget(var7);
                        }
                    }
                } else {
                    ((EntityMonsterPatrolling)this.mob).findPatrolTarget();
                }
            }
        }

        private List<EntityMonsterPatrolling> findPatrolCompanions() {
            return ((EntityMonsterPatrolling)this.mob).level.getEntitiesOfClass(EntityMonsterPatrolling.class, ((Entity)this.mob).getBoundingBox().inflate(16.0), var0 -> var0.canJoinPatrol() && !var0.is((Entity)this.mob));
        }

        private boolean moveRandomly() {
            RandomSource var0 = ((EntityLiving)this.mob).getRandom();
            BlockPosition var1 = ((EntityMonsterPatrolling)this.mob).level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, ((Entity)this.mob).blockPosition().offset(-8 + var0.nextInt(16), 0, -8 + var0.nextInt(16)));
            return ((EntityInsentient)this.mob).getNavigation().moveTo(var1.getX(), var1.getY(), var1.getZ(), this.speedModifier);
        }
    }
}

