/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging
implements VariantHolder<Holder<PaintingVariant>> {
    private static final DataWatcherObject<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = DataWatcher.defineId(EntityPainting.class, DataWatcherRegistry.PAINTING_VARIANT);
    private static final ResourceKey<PaintingVariant> DEFAULT_VARIANT = PaintingVariants.KEBAB;

    private static Holder<PaintingVariant> getDefaultVariant() {
        return BuiltInRegistries.PAINTING_VARIANT.getHolderOrThrow(DEFAULT_VARIANT);
    }

    public EntityPainting(EntityTypes<? extends EntityPainting> var0, World var1) {
        super((EntityTypes<? extends EntityHanging>)var0, var1);
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_PAINTING_VARIANT_ID, EntityPainting.getDefaultVariant());
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_PAINTING_VARIANT_ID.equals(var0)) {
            this.recalculateBoundingBox();
        }
    }

    @Override
    public void setVariant(Holder<PaintingVariant> var0) {
        this.entityData.set(DATA_PAINTING_VARIANT_ID, var0);
    }

    @Override
    public Holder<PaintingVariant> getVariant() {
        return this.entityData.get(DATA_PAINTING_VARIANT_ID);
    }

    public static Optional<EntityPainting> create(World var0, BlockPosition var12, EnumDirection var2) {
        EntityPainting var3 = new EntityPainting(var0, var12);
        ArrayList<Holder> var4 = new ArrayList<Holder>();
        BuiltInRegistries.PAINTING_VARIANT.getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(var4::add);
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        var3.setDirection(var2);
        var4.removeIf(var1 -> {
            var3.setVariant((Holder<PaintingVariant>)var1);
            return !var3.survives();
        });
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        int var5 = var4.stream().mapToInt(EntityPainting::variantArea).max().orElse(0);
        var4.removeIf(var1 -> EntityPainting.variantArea(var1) < var5);
        Optional var6 = SystemUtils.getRandomSafe(var4, var3.random);
        if (var6.isEmpty()) {
            return Optional.empty();
        }
        var3.setVariant((Holder)var6.get());
        var3.setDirection(var2);
        return Optional.of(var3);
    }

    private static int variantArea(Holder<PaintingVariant> var0) {
        return var0.value().getWidth() * var0.value().getHeight();
    }

    private EntityPainting(World var0, BlockPosition var1) {
        super(EntityTypes.PAINTING, var0, var1);
    }

    public EntityPainting(World var0, BlockPosition var1, EnumDirection var2, Holder<PaintingVariant> var3) {
        this(var0, var1);
        this.setVariant(var3);
        this.setDirection(var2);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putString("variant", this.getVariant().unwrapKey().orElse(DEFAULT_VARIANT).location().toString());
        var0.putByte("facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        Holder var1 = Optional.ofNullable(MinecraftKey.tryParse(var02.getString("variant"))).map(var0 -> ResourceKey.create(Registries.PAINTING_VARIANT, var0)).flatMap(BuiltInRegistries.PAINTING_VARIANT::getHolder).map(var0 -> var0).orElseGet(EntityPainting::getDefaultVariant);
        this.setVariant(var1);
        this.direction = EnumDirection.from2DDataValue(var02.getByte("facing"));
        super.readAdditionalSaveData(var02);
        this.setDirection(this.direction);
    }

    @Override
    public int getWidth() {
        return ((PaintingVariant)this.getVariant().value()).getWidth();
    }

    @Override
    public int getHeight() {
        return ((PaintingVariant)this.getVariant().value()).getHeight();
    }

    @Override
    public void dropItem(@Nullable Entity var0) {
        if (!this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        this.playSound(SoundEffects.PAINTING_BREAK, 1.0f, 1.0f);
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (var1.getAbilities().instabuild) {
                return;
            }
        }
        this.spawnAtLocation(Items.PAINTING);
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEffects.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void moveTo(double var0, double var2, double var4, float var6, float var7) {
        this.setPos(var0, var2, var4);
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
        this.setPos(var0, var2, var4);
    }

    @Override
    public Vec3D trackingPosition() {
        return Vec3D.atLowerCornerOf(this.pos);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this, this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.setDirection(EnumDirection.from3DDataValue(var0.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }
}

