/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityLeash
extends EntityHanging {
    public static final double OFFSET_Y = 0.375;

    public EntityLeash(EntityTypes<? extends EntityLeash> var0, World var1) {
        super((EntityTypes<? extends EntityHanging>)var0, var1);
    }

    public EntityLeash(World var0, BlockPosition var1) {
        super(EntityTypes.LEASH_KNOT, var0, var1);
        this.setPos(var1.getX(), var1.getY(), var1.getZ());
    }

    @Override
    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double var0 = (double)this.getType().getWidth() / 2.0;
        double var2 = this.getType().getHeight();
        this.setBoundingBox(new AxisAlignedBB(this.getX() - var0, this.getY(), this.getZ() - var0, this.getX() + var0, this.getY() + var2, this.getZ() + var0));
    }

    @Override
    public void setDirection(EnumDirection var0) {
    }

    @Override
    public int getWidth() {
        return 9;
    }

    @Override
    public int getHeight() {
        return 9;
    }

    @Override
    protected float getEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.0625f;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 1024.0;
    }

    @Override
    public void dropItem(@Nullable Entity var0) {
        this.playSound(SoundEffects.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (this.level.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        boolean var2 = false;
        double var3 = 7.0;
        List<EntityInsentient> var5 = this.level.getEntitiesOfClass(EntityInsentient.class, new AxisAlignedBB(this.getX() - 7.0, this.getY() - 7.0, this.getZ() - 7.0, this.getX() + 7.0, this.getY() + 7.0, this.getZ() + 7.0));
        for (EntityInsentient var7 : var5) {
            if (var7.getLeashHolder() != var0) continue;
            var7.setLeashedTo(this, true);
            var2 = true;
        }
        if (!var2) {
            this.discard();
            if (var0.getAbilities().instabuild) {
                for (EntityInsentient var7 : var5) {
                    if (!var7.isLeashed() || var7.getLeashHolder() != this) continue;
                    var7.dropLeash(true, false);
                }
            }
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public boolean survives() {
        return this.level.getBlockState(this.pos).is(TagsBlock.FENCES);
    }

    public static EntityLeash getOrCreateKnot(World var0, BlockPosition var1) {
        int var2 = var1.getX();
        int var3 = var1.getY();
        int var4 = var1.getZ();
        List<EntityLeash> var5 = var0.getEntitiesOfClass(EntityLeash.class, new AxisAlignedBB((double)var2 - 1.0, (double)var3 - 1.0, (double)var4 - 1.0, (double)var2 + 1.0, (double)var3 + 1.0, (double)var4 + 1.0));
        for (EntityLeash var7 : var5) {
            if (!var7.getPos().equals(var1)) continue;
            return var7;
        }
        EntityLeash var6 = new EntityLeash(var0, var1);
        var0.addFreshEntity(var6);
        return var6;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEffects.LEASH_KNOT_PLACE, 1.0f, 1.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this, 0, this.getPos());
    }

    @Override
    public Vec3D getRopeHoldPosition(float var0) {
        return this.getPosition(var0).add(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.LEAD);
    }
}

