/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class Goat
extends EntityAnimal {
    public static final EntitySize LONG_JUMPING_DIMENSIONS = EntitySize.scalable(0.9f, 1.3f).scale(0.7f);
    private static final int ADULT_ATTACK_DAMAGE = 2;
    private static final int BABY_ATTACK_DAMAGE = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.NEAREST_ADULT, SensorType.HURT_BY, SensorType.GOAT_TEMPTATIONS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.BREED_TARGET, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, MemoryModuleType.LONG_JUMP_MID_JUMP, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.IS_TEMPTED, MemoryModuleType.RAM_COOLDOWN_TICKS, MemoryModuleType.RAM_TARGET, MemoryModuleType.IS_PANICKING});
    public static final int GOAT_FALL_DAMAGE_REDUCTION = 10;
    public static final double GOAT_SCREAMING_CHANCE = 0.02;
    public static final double UNIHORN_CHANCE = (double)0.1f;
    private static final DataWatcherObject<Boolean> DATA_IS_SCREAMING_GOAT = DataWatcher.defineId(Goat.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Boolean> DATA_HAS_LEFT_HORN = DataWatcher.defineId(Goat.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Boolean> DATA_HAS_RIGHT_HORN = DataWatcher.defineId(Goat.class, DataWatcherRegistry.BOOLEAN);
    private boolean isLoweringHead;
    private int lowerHeadTick;

    public Goat(EntityTypes<? extends Goat> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    public ItemStack createHorn() {
        RandomSource var0 = RandomSource.create(this.getUUID().hashCode());
        TagKey<Instrument> var1 = this.isScreamingGoat() ? InstrumentTags.SCREAMING_GOAT_HORNS : InstrumentTags.REGULAR_GOAT_HORNS;
        HolderSet.Named<Instrument> var2 = BuiltInRegistries.INSTRUMENT.getOrCreateTag(var1);
        return InstrumentItem.create(Items.GOAT_HORN, var2.getRandomElement(var0).get());
    }

    protected BehaviorController.b<Goat> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return GoatAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.MOVEMENT_SPEED, 0.2f).add(GenericAttributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
            this.removeHorns();
        } else {
            this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(2.0);
            this.addHorns();
        }
    }

    @Override
    protected int calculateFallDamage(float var0, float var1) {
        return super.calculateFallDamage(var0, var1) - 10;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isScreamingGoat()) {
            return SoundEffects.GOAT_SCREAMING_AMBIENT;
        }
        return SoundEffects.GOAT_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isScreamingGoat()) {
            return SoundEffects.GOAT_SCREAMING_HURT;
        }
        return SoundEffects.GOAT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        if (this.isScreamingGoat()) {
            return SoundEffects.GOAT_SCREAMING_DEATH;
        }
        return SoundEffects.GOAT_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.GOAT_STEP, 0.15f, 1.0f);
    }

    protected SoundEffect getMilkingSound() {
        if (this.isScreamingGoat()) {
            return SoundEffects.GOAT_SCREAMING_MILK;
        }
        return SoundEffects.GOAT_MILK;
    }

    @Override
    @Nullable
    public Goat getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        Goat var2 = EntityTypes.GOAT.create(var0);
        if (var2 != null) {
            EntityAgeable var5;
            GoatAi.initMemories(var2, var0.getRandom());
            EntityAgeable var3 = var0.getRandom().nextBoolean() ? this : var1;
            boolean var4 = var3 instanceof Goat && ((Goat)(var5 = var3)).isScreamingGoat() || var0.getRandom().nextDouble() < 0.02;
            var2.setScreamingGoat(var4);
        }
        return var2;
    }

    public BehaviorController<Goat> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("goatBrain");
        this.getBrain().tick((WorldServer)this.level, this);
        this.level.getProfiler().pop();
        this.level.getProfiler().push("goatActivityUpdate");
        GoatAi.updateActivity(this);
        this.level.getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    public int getMaxHeadYRot() {
        return 15;
    }

    @Override
    public void setYHeadRot(float var0) {
        int var1 = this.getMaxHeadYRot();
        float var2 = MathHelper.degreesDifference(this.yBodyRot, var0);
        float var3 = MathHelper.clamp(var2, (float)(-var1), (float)var1);
        super.setYHeadRot(this.yBodyRot + var3);
    }

    @Override
    public SoundEffect getEatingSound(ItemStack var0) {
        return this.isScreamingGoat() ? SoundEffects.GOAT_SCREAMING_EAT : SoundEffects.GOAT_EAT;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.BUCKET) && !this.isBaby()) {
            var0.playSound(this.getMilkingSound(), 1.0f, 1.0f);
            ItemStack var3 = ItemLiquidUtil.createFilledResult(var2, var0, Items.MILK_BUCKET.getDefaultInstance());
            var0.setItemInHand(var1, var3);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        EnumInteractionResult var3 = super.mobInteract(var0, var1);
        if (var3.consumesAction() && this.isFood(var2)) {
            this.level.playSound(null, this, this.getEatingSound(var2), SoundCategory.NEUTRAL, 1.0f, MathHelper.randomBetween(this.level.random, 0.8f, 1.2f));
        }
        return var3;
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        RandomSource var5 = var0.getRandom();
        GoatAi.initMemories(this, var5);
        this.setScreamingGoat(var5.nextDouble() < 0.02);
        this.ageBoundaryReached();
        if (!this.isBaby() && (double)var5.nextFloat() < (double)0.1f) {
            DataWatcherObject<Boolean> var6 = var5.nextBoolean() ? DATA_HAS_LEFT_HORN : DATA_HAS_RIGHT_HORN;
            this.entityData.set(var6, false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return var0 == EntityPose.LONG_JUMPING ? LONG_JUMPING_DIMENSIONS.scale(this.getScale()) : super.getDimensions(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsScreamingGoat", this.isScreamingGoat());
        var0.putBoolean("HasLeftHorn", this.hasLeftHorn());
        var0.putBoolean("HasRightHorn", this.hasRightHorn());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setScreamingGoat(var0.getBoolean("IsScreamingGoat"));
        this.entityData.set(DATA_HAS_LEFT_HORN, var0.getBoolean("HasLeftHorn"));
        this.entityData.set(DATA_HAS_RIGHT_HORN, var0.getBoolean("HasRightHorn"));
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 58) {
            this.isLoweringHead = true;
        } else if (var0 == 59) {
            this.isLoweringHead = false;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public void aiStep() {
        this.lowerHeadTick = this.isLoweringHead ? ++this.lowerHeadTick : (this.lowerHeadTick -= 2);
        this.lowerHeadTick = MathHelper.clamp(this.lowerHeadTick, 0, 20);
        super.aiStep();
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_IS_SCREAMING_GOAT, false);
        this.entityData.define(DATA_HAS_LEFT_HORN, true);
        this.entityData.define(DATA_HAS_RIGHT_HORN, true);
    }

    public boolean hasLeftHorn() {
        return this.entityData.get(DATA_HAS_LEFT_HORN);
    }

    public boolean hasRightHorn() {
        return this.entityData.get(DATA_HAS_RIGHT_HORN);
    }

    public boolean dropHorn() {
        boolean var0 = this.hasLeftHorn();
        boolean var1 = this.hasRightHorn();
        if (!var0 && !var1) {
            return false;
        }
        DataWatcherObject<Boolean> var2 = !var0 ? DATA_HAS_RIGHT_HORN : (!var1 ? DATA_HAS_LEFT_HORN : (this.random.nextBoolean() ? DATA_HAS_LEFT_HORN : DATA_HAS_RIGHT_HORN));
        this.entityData.set(var2, false);
        Vec3D var3 = this.position();
        ItemStack var4 = this.createHorn();
        double var5 = MathHelper.randomBetween(this.random, -0.2f, 0.2f);
        double var7 = MathHelper.randomBetween(this.random, 0.3f, 0.7f);
        double var9 = MathHelper.randomBetween(this.random, -0.2f, 0.2f);
        EntityItem var11 = new EntityItem(this.level, var3.x(), var3.y(), var3.z(), var4, var5, var7, var9);
        this.level.addFreshEntity(var11);
        return true;
    }

    public void addHorns() {
        this.entityData.set(DATA_HAS_LEFT_HORN, true);
        this.entityData.set(DATA_HAS_RIGHT_HORN, true);
    }

    public void removeHorns() {
        this.entityData.set(DATA_HAS_LEFT_HORN, false);
        this.entityData.set(DATA_HAS_RIGHT_HORN, false);
    }

    public boolean isScreamingGoat() {
        return this.entityData.get(DATA_IS_SCREAMING_GOAT);
    }

    public void setScreamingGoat(boolean var0) {
        this.entityData.set(DATA_IS_SCREAMING_GOAT, var0);
    }

    public float getRammingXHeadRot() {
        return (float)this.lowerHeadTick / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean checkGoatSpawnRules(EntityTypes<? extends EntityAnimal> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.GOATS_SPAWNABLE_ON) && Goat.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

