/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class Camel
extends EntityHorseAbstract
implements IJumpable,
RiderShieldingMount,
ISaddleable {
    public static final RecipeItemStack TEMPTATION_ITEM = RecipeItemStack.of(Items.CACTUS);
    public static final int DASH_COOLDOWN_TICKS = 55;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    public static final DataWatcherObject<Boolean> DASH = DataWatcher.defineId(Camel.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Long> LAST_POSE_CHANGE_TICK = DataWatcher.defineId(Camel.class, DataWatcherRegistry.LONG);
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntitySize SITTING_DIMENSIONS = EntitySize.scalable(EntityTypes.CAMEL.getWidth(), EntityTypes.CAMEL.getHeight() - 1.43f);
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;

    public Camel(EntityTypes<? extends Camel> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
        this.maxUpStep = 1.5f;
        Navigation var2 = (Navigation)this.getNavigation();
        var2.setCanFloat(true);
        var2.setCanWalkOverFences(true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsSitting", this.getPose() == EntityPose.SITTING);
        var0.putLong("LastPoseTick", this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.getBoolean("IsSitting")) {
            this.setPose(EntityPose.SITTING);
        }
        this.resetLastPoseChangeTick(var0.getLong("LastPoseTick"));
    }

    public static AttributeProvider.Builder createAttributes() {
        return Camel.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 32.0).add(GenericAttributes.MOVEMENT_SPEED, 0.09f).add(GenericAttributes.JUMP_STRENGTH, 0.42f);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DASH, false);
        this.entityData.define(LAST_POSE_CHANGE_TICK, -52L);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        CamelAi.initMemories(this, var0.getRandom());
        this.entityData.set(LAST_POSE_CHANGE_TICK, var0.getLevel().getGameTime() - 52L);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    protected BehaviorController.b<Camel> brainProvider() {
        return CamelAi.brainProvider();
    }

    @Override
    protected void registerGoals() {
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return CamelAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return var0 == EntityPose.SITTING ? SITTING_DIMENSIONS.scale(this.getScale()) : super.getDimensions(var0);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height - 0.1f;
    }

    @Override
    public double getRiderShieldingHeight() {
        return 0.5;
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("camelBrain");
        BehaviorController<?> var0 = this.getBrain();
        var0.tick((WorldServer)this.level, this);
        this.level.getProfiler().pop();
        this.level.getProfiler().push("camelActivityUpdate");
        CamelAi.updateActivity(this);
        this.level.getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 55 && (this.onGround || this.isInWater())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.level.playSound(null, this.blockPosition(), SoundEffects.CAMEL_DASH_READY, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.level.isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        switch (this.getPose()) {
            case STANDING: {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.stop();
                this.dashAnimationState.animateWhen(this.isDashing(), this.tickCount);
                this.sitUpAnimationState.animateWhen(this.isInPoseTransition(), this.tickCount);
                this.walkAnimationState.animateWhen((this.onGround || this.hasControllingPassenger()) && this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6, this.tickCount);
                break;
            }
            case SITTING: {
                this.walkAnimationState.stop();
                this.sitUpAnimationState.stop();
                this.dashAnimationState.stop();
                if (this.isSittingDown()) {
                    this.sitAnimationState.startIfStopped(this.tickCount);
                    this.sitPoseAnimationState.stop();
                    break;
                }
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
                break;
            }
            default: {
                this.walkAnimationState.stop();
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.stop();
                this.sitUpAnimationState.stop();
                this.dashAnimationState.stop();
            }
        }
    }

    @Override
    public void travel(Vec3D var0) {
        if (!this.isAlive()) {
            return;
        }
        if (this.refuseToMove() && this.isOnGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            var0 = var0.multiply(0.0, 1.0, 0.0);
        }
        super.travel(var0);
    }

    public boolean refuseToMove() {
        return this.isPoseSitting() || this.isInPoseTransition();
    }

    @Override
    protected float getDrivenMovementSpeed(EntityLiving var0) {
        float var1 = var0.isSprinting() && this.getJumpCooldown() == 0 ? 0.1f : 0.0f;
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) + var1;
    }

    @Override
    protected boolean mountIgnoresControllerInput(EntityLiving var0) {
        boolean var1 = this.isInPoseTransition();
        if (this.isPoseSitting() && !var1 && var0.zza > 0.0f) {
            this.standUp();
        }
        return this.refuseToMove() || super.mountIgnoresControllerInput(var0);
    }

    @Override
    public boolean canJump(EntityHuman var0) {
        return !this.refuseToMove() && this.getControllingPassenger() == var0 && super.canJump(var0);
    }

    @Override
    public void onPlayerJump(int var0) {
        if (!this.isSaddled() || this.dashCooldown > 0 || !this.isOnGround()) {
            return;
        }
        super.onPlayerJump(var0);
    }

    @Override
    protected void executeRidersJump(float var0, float var1, float var2) {
        double var3 = this.getAttributeValue(GenericAttributes.JUMP_STRENGTH) * (double)this.getBlockJumpFactor() + this.getJumpBoostPower();
        this.addDeltaMovement(this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale((double)(22.2222f * var0) * this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()).add(0.0, (double)(1.4285f * var0) * var3, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.hasImpulse = true;
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean var0) {
        this.entityData.set(DASH, var0);
    }

    public boolean isPanicking() {
        return this.getBrain().checkMemory(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_PRESENT);
    }

    @Override
    public void handleStartJump(int var0) {
        this.playSound(SoundEffects.CAMEL_DASH, 1.0f, 1.0f);
        this.setDashing(true);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.CAMEL_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAMEL_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CAMEL_HURT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.getSoundType() == SoundEffectType.SAND) {
            this.playSound(SoundEffects.CAMEL_STEP_SAND, 1.0f, 1.0f);
        } else {
            this.playSound(SoundEffects.CAMEL_STEP, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return TEMPTATION_ITEM.test(var0);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var0.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(var0);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        EnumInteractionResult var3 = var2.interactLivingEntity(var0, this, var1);
        if (var3.consumesAction()) {
            return var3;
        }
        if (this.isFood(var2)) {
            return this.fedFood(var0, var2);
        }
        if (this.getPassengers().size() < 2 && !this.isBaby()) {
            this.doPlayerRide(var0);
        }
        return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
    }

    @Override
    protected void onLeashDistance(float var0) {
        if (var0 > 6.0f && this.isPoseSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    @Override
    protected boolean handleEating(EntityHuman var0, ItemStack var1) {
        boolean var4;
        boolean var3;
        boolean var2;
        if (!this.isFood(var1)) {
            return false;
        }
        boolean bl = var2 = this.getHealth() < this.getMaxHealth();
        if (var2) {
            this.heal(2.0f);
        }
        boolean bl2 = var3 = this.isTamed() && this.getAge() == 0 && this.canFallInLove();
        if (var3) {
            this.setInLove(var0);
        }
        if (var4 = this.isBaby()) {
            this.level.addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level.isClientSide) {
                this.ageUp(10);
            }
        }
        if (var2 || var3 || var4) {
            SoundEffect var5;
            if (!this.isSilent() && (var5 = this.getEatingSound()) != null) {
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), var5, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) return false;
        if (!(var0 instanceof Camel)) return false;
        Camel var1 = (Camel)var0;
        if (!this.canParent()) return false;
        if (!var1.canParent()) return false;
        return true;
    }

    @Override
    @Nullable
    public Camel getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.CAMEL.create(var0);
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.CAMEL_EAT;
    }

    @Override
    protected void actuallyHurt(DamageSource var0, float var1) {
        this.standUpPanic();
        super.actuallyHurt(var0, var1);
    }

    @Override
    public void positionRider(Entity var0) {
        int var1 = this.getPassengers().indexOf(var0);
        if (var1 < 0) {
            return;
        }
        boolean var2 = var1 == 0;
        float var3 = 0.5f;
        float var4 = (float)(this.isRemoved() ? (double)0.01f : this.getBodyAnchorAnimationYOffset(var2, 0.0f) + var0.getMyRidingOffset());
        if (this.getPassengers().size() > 1) {
            if (!var2) {
                var3 = -0.7f;
            }
            if (var0 instanceof EntityAnimal) {
                var3 += 0.2f;
            }
        }
        Vec3D var5 = new Vec3D(0.0, 0.0, var3).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        var0.setPos(this.getX() + var5.x, this.getY() + (double)var4, this.getZ() + var5.z);
        this.clampRotation(var0);
    }

    private double getBodyAnchorAnimationYOffset(boolean var0, float var1) {
        boolean var8;
        double var2 = this.getPassengersRidingOffset();
        float var4 = this.getScale() * 1.43f;
        float var5 = var4 - this.getScale() * 0.2f;
        float var6 = var4 - var5;
        boolean var7 = this.isInPoseTransition();
        boolean bl = var8 = this.getPose() == EntityPose.SITTING;
        if (var7) {
            float var11;
            int var10;
            int var9;
            int n2 = var9 = var8 ? 40 : 52;
            if (var8) {
                var10 = 28;
                var11 = var0 ? 0.5f : 0.1f;
            } else {
                var10 = var0 ? 24 : 32;
                var11 = var0 ? 0.6f : 0.35f;
            }
            float var12 = (float)this.getPoseTime() + var1;
            boolean var13 = var12 < (float)var10;
            float var14 = var13 ? var12 / (float)var10 : (var12 - (float)var10) / (float)(var9 - var10);
            float var15 = var4 - var11 * var5;
            var2 += var8 ? (double)MathHelper.lerp(var14, var13 ? var4 : var15, var13 ? var15 : var6) : (double)MathHelper.lerp(var14, var13 ? var6 - var4 : var6 - var15, var13 ? var6 - var15 : 0.0f);
        }
        if (var8 && !var7) {
            var2 += (double)var6;
        }
        return var2;
    }

    @Override
    public Vec3D getLeashOffset(float var0) {
        return new Vec3D(0.0, this.getBodyAnchorAnimationYOffset(true, var0) - (double)(0.2f * this.getScale()), this.getBbWidth() * 0.56f);
    }

    @Override
    public double getPassengersRidingOffset() {
        return this.getDimensions((EntityPose)this.getPose()).height - (this.isBaby() ? 0.35f : 0.6f);
    }

    @Override
    public void onPassengerTurned(Entity var0) {
        if (this.getControllingPassenger() != var0) {
            this.clampRotation(var0);
        }
    }

    private void clampRotation(Entity var0) {
        var0.setYBodyRot(this.getYRot());
        float var1 = var0.getYRot();
        float var2 = MathHelper.wrapDegrees(var1 - this.getYRot());
        float var3 = MathHelper.clamp(var2, -160.0f, 160.0f);
        var0.yRotO += var3 - var2;
        float var4 = var1 + var3 - var2;
        var0.setYRot(var4);
        var0.setYHeadRot(var4);
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return this.getPassengers().size() <= 2;
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity var0;
        if (!this.getPassengers().isEmpty() && this.isSaddled() && (var0 = this.getPassengers().get(0)) instanceof EntityLiving) {
            EntityLiving var1 = (EntityLiving)var0;
            return var1;
        }
        return null;
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public boolean isPoseSitting() {
        return this.getPose() == EntityPose.SITTING;
    }

    public boolean isInPoseTransition() {
        long var0 = this.getPoseTime();
        return switch (this.getPose()) {
            case EntityPose.STANDING -> {
                if (var0 < 52L) {
                    yield true;
                }
                yield false;
            }
            case EntityPose.SITTING -> {
                if (var0 < 40L) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isSittingDown() {
        return this.getPose() == EntityPose.SITTING && this.getPoseTime() < 40L;
    }

    public void sitDown() {
        if (this.hasPose(EntityPose.SITTING)) {
            return;
        }
        this.playSound(SoundEffects.CAMEL_SIT, 1.0f, 1.0f);
        this.setPose(EntityPose.SITTING);
        this.resetLastPoseChangeTick(this.level.getGameTime());
    }

    public void standUp() {
        if (this.hasPose(EntityPose.STANDING)) {
            return;
        }
        this.playSound(SoundEffects.CAMEL_STAND, 1.0f, 1.0f);
        this.setPose(EntityPose.STANDING);
        this.resetLastPoseChangeTick(this.level.getGameTime());
    }

    public void standUpPanic() {
        this.setPose(EntityPose.STANDING);
        this.resetLastPoseChangeTick(this.level.getGameTime() - 52L);
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long var0) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, var0);
    }

    public long getPoseTime() {
        return this.level.getGameTime() - this.entityData.get(LAST_POSE_CHANGE_TICK);
    }

    @Override
    public SoundEffect getSaddleSoundEvent() {
        return SoundEffects.CAMEL_SADDLE;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (!this.firstTick && DASH.equals(var0)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new a(this);
    }

    @Override
    public boolean isTamed() {
        return true;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        if (!this.level.isClientSide) {
            var0.openHorseInventory(this, this.inventory);
        }
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getControllingPassenger() {
        return this.getControllingPassenger();
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel var1) {
            super(var1);
        }

        @Override
        public void clientTick() {
            if (!Camel.this.refuseToMove()) {
                super.clientTick();
            }
        }
    }
}

