/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<CatVariant> {
    public static final double TEMPT_SPEED_MOD = 0.6;
    public static final double WALK_SPEED_MOD = 0.8;
    public static final double SPRINT_SPEED_MOD = 1.33;
    private static final RecipeItemStack TEMPT_INGREDIENT = RecipeItemStack.of(Items.COD, Items.SALMON);
    private static final DataWatcherObject<CatVariant> DATA_VARIANT_ID = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.CAT_VARIANT);
    private static final DataWatcherObject<Boolean> IS_LYING = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> RELAX_STATE_ONE = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_COLLAR_COLOR = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.INT);
    private a<EntityHuman> avoidPlayersGoal;
    @Nullable
    private PathfinderGoalTempt temptGoal;
    private float lieDownAmount;
    private float lieDownAmountO;
    private float lieDownAmountTail;
    private float lieDownAmountOTail;
    private float relaxStateOneAmount;
    private float relaxStateOneAmountO;

    public EntityCat(EntityTypes<? extends EntityCat> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
    }

    public MinecraftKey getResourceLocation() {
        return this.getVariant().texture();
    }

    @Override
    protected void registerGoals() {
        this.temptGoal = new PathfinderGoalTemptChance(this, 0.6, TEMPT_INGREDIENT, true);
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalSit(this));
        this.goalSelector.addGoal(2, new b(this));
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.goalSelector.addGoal(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f, false));
        this.goalSelector.addGoal(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.goalSelector.addGoal(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.goalSelector.addGoal(9, new PathfinderGoalOcelotAttack(this));
        this.goalSelector.addGoal(10, new PathfinderGoalBreed(this, 0.8));
        this.goalSelector.addGoal(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.goalSelector.addGoal(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, null));
        this.targetSelector.addGoal(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    @Override
    public CatVariant getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public void setVariant(CatVariant var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public void setLying(boolean var0) {
        this.entityData.set(IS_LYING, var0);
    }

    public boolean isLying() {
        return this.entityData.get(IS_LYING);
    }

    public void setRelaxStateOne(boolean var0) {
        this.entityData.set(RELAX_STATE_ONE, var0);
    }

    public boolean isRelaxStateOne() {
        return this.entityData.get(RELAX_STATE_ONE);
    }

    public EnumColor getCollarColor() {
        return EnumColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(EnumColor var0) {
        this.entityData.set(DATA_COLLAR_COLOR, var0.getId());
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_VARIANT_ID, BuiltInRegistries.CAT_VARIANT.getOrThrow(CatVariant.BLACK));
        this.entityData.define(IS_LYING, false);
        this.entityData.define(RELAX_STATE_ONE, false);
        this.entityData.define(DATA_COLLAR_COLOR, EnumColor.RED.getId());
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("variant", BuiltInRegistries.CAT_VARIANT.getKey(this.getVariant()).toString());
        var0.putByte("CollarColor", (byte)this.getCollarColor().getId());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        CatVariant var1 = BuiltInRegistries.CAT_VARIANT.get(MinecraftKey.tryParse(var0.getString("variant")));
        if (var1 != null) {
            this.setVariant(var1);
        }
        if (var0.contains("CollarColor", 99)) {
            this.setCollarColor(EnumColor.byId(var0.getInt("CollarColor")));
        }
    }

    @Override
    public void customServerAiStep() {
        if (this.getMoveControl().hasWanted()) {
            double var0 = this.getMoveControl().getSpeedModifier();
            if (var0 == 0.6) {
                this.setPose(EntityPose.CROUCHING);
                this.setSprinting(false);
            } else if (var0 == 1.33) {
                this.setPose(EntityPose.STANDING);
                this.setSprinting(true);
            } else {
                this.setPose(EntityPose.STANDING);
                this.setSprinting(false);
            }
        } else {
            this.setPose(EntityPose.STANDING);
            this.setSprinting(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.isTame()) {
            if (this.isInLove()) {
                return SoundEffects.CAT_PURR;
            }
            if (this.random.nextInt(4) == 0) {
                return SoundEffects.CAT_PURREOW;
            }
            return SoundEffects.CAT_AMBIENT;
        }
        return SoundEffects.CAT_STRAY_AMBIENT;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    public void hiss() {
        this.playSound(SoundEffects.CAT_HISS, this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CAT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAT_DEATH;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        return false;
    }

    @Override
    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (this.isFood(var2)) {
            this.playSound(SoundEffects.CAT_EAT, 1.0f, 1.0f);
        }
        super.usePlayerItem(var0, var1, var2);
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        return var0.hurt(DamageSource.mobAttack(this), this.getAttackDamage());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.temptGoal != null && this.temptGoal.isRunning() && !this.isTame() && this.tickCount % 100 == 0) {
            this.playSound(SoundEffects.CAT_BEG_FOR_FOOD, 1.0f, 1.0f);
        }
        this.handleLieDown();
    }

    private void handleLieDown() {
        if ((this.isLying() || this.isRelaxStateOne()) && this.tickCount % 5 == 0) {
            this.playSound(SoundEffects.CAT_PURR, 0.6f + 0.4f * (this.random.nextFloat() - this.random.nextFloat()), 1.0f);
        }
        this.updateLieDownAmount();
        this.updateRelaxStateOneAmount();
    }

    private void updateLieDownAmount() {
        this.lieDownAmountO = this.lieDownAmount;
        this.lieDownAmountOTail = this.lieDownAmountTail;
        if (this.isLying()) {
            this.lieDownAmount = Math.min(1.0f, this.lieDownAmount + 0.15f);
            this.lieDownAmountTail = Math.min(1.0f, this.lieDownAmountTail + 0.08f);
        } else {
            this.lieDownAmount = Math.max(0.0f, this.lieDownAmount - 0.22f);
            this.lieDownAmountTail = Math.max(0.0f, this.lieDownAmountTail - 0.13f);
        }
    }

    private void updateRelaxStateOneAmount() {
        this.relaxStateOneAmountO = this.relaxStateOneAmount;
        this.relaxStateOneAmount = this.isRelaxStateOne() ? Math.min(1.0f, this.relaxStateOneAmount + 0.1f) : Math.max(0.0f, this.relaxStateOneAmount - 0.13f);
    }

    public float getLieDownAmount(float var0) {
        return MathHelper.lerp(var0, this.lieDownAmountO, this.lieDownAmount);
    }

    public float getLieDownAmountTail(float var0) {
        return MathHelper.lerp(var0, this.lieDownAmountOTail, this.lieDownAmountTail);
    }

    public float getRelaxStateOneAmount(float var0) {
        return MathHelper.lerp(var0, this.relaxStateOneAmountO, this.relaxStateOneAmount);
    }

    @Override
    @Nullable
    public EntityCat getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityCat var2 = EntityTypes.CAT.create(var0);
        if (var2 != null && var1 instanceof EntityCat) {
            EntityCat var3 = (EntityCat)var1;
            if (this.random.nextBoolean()) {
                var2.setVariant(this.getVariant());
            } else {
                var2.setVariant(var3.getVariant());
            }
            if (this.isTame()) {
                var2.setOwnerUUID(this.getOwnerUUID());
                var2.setTame(true);
                if (this.random.nextBoolean()) {
                    var2.setCollarColor(this.getCollarColor());
                } else {
                    var2.setCollarColor(var3.getCollarColor());
                }
            }
        }
        return var2;
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (!this.isTame()) {
            return false;
        }
        if (!(var0 instanceof EntityCat)) {
            return false;
        }
        EntityCat var1 = (EntityCat)var0;
        return var1.isTame() && super.canMate(var0);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var02, DifficultyDamageScaler var12, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        var3 = super.finalizeSpawn(var02, var12, var2, var3, var4);
        boolean var5 = var02.getMoonBrightness() > 0.9f;
        TagKey<CatVariant> var6 = var5 ? CatVariantTags.FULL_MOON_SPAWNS : CatVariantTags.DEFAULT_SPAWNS;
        BuiltInRegistries.CAT_VARIANT.getTag(var6).flatMap(var1 -> var1.getRandomElement(var02.getRandom())).ifPresent(var0 -> this.setVariant((CatVariant)var0.value()));
        WorldServer var7 = var02.getLevel();
        if (var7.structureManager().getStructureWithPieceAt(this.blockPosition(), StructureTags.CATS_SPAWN_AS_BLACK).isValid()) {
            this.setVariant(BuiltInRegistries.CAT_VARIANT.getOrThrow(CatVariant.ALL_BLACK));
            this.setPersistenceRequired();
        }
        return var3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        Enum var4;
        ItemStack var2 = var0.getItemInHand(var1);
        Item var3 = var2.getItem();
        if (this.level.isClientSide) {
            if (this.isTame() && this.isOwnedBy(var0)) {
                return EnumInteractionResult.SUCCESS;
            }
            if (this.isFood(var2) && (this.getHealth() < this.getMaxHealth() || !this.isTame())) {
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isOwnedBy(var0)) {
                if (var3 instanceof ItemDye) {
                    var4 = ((ItemDye)var3).getDyeColor();
                    if (var4 != this.getCollarColor()) {
                        this.setCollarColor((EnumColor)var4);
                        if (!var0.getAbilities().instabuild) {
                            var2.shrink(1);
                        }
                        this.setPersistenceRequired();
                        return EnumInteractionResult.CONSUME;
                    }
                } else {
                    if (var3.isEdible() && this.isFood(var2) && this.getHealth() < this.getMaxHealth()) {
                        this.usePlayerItem(var0, var1, var2);
                        this.heal(var3.getFoodProperties().getNutrition());
                        return EnumInteractionResult.CONSUME;
                    }
                    EnumInteractionResult var42 = super.mobInteract(var0, var1);
                    if (!var42.consumesAction() || this.isBaby()) {
                        this.setOrderedToSit(!this.isOrderedToSit());
                    }
                    return var42;
                }
            }
        } else if (this.isFood(var2)) {
            this.usePlayerItem(var0, var1, var2);
            if (this.random.nextInt(3) == 0) {
                this.tame(var0);
                this.setOrderedToSit(true);
                this.level.broadcastEntityEvent(this, (byte)7);
            } else {
                this.level.broadcastEntityEvent(this, (byte)6);
            }
            this.setPersistenceRequired();
            return EnumInteractionResult.CONSUME;
        }
        if (((EnumInteractionResult)(var4 = super.mobInteract(var0, var1))).consumesAction()) {
            this.setPersistenceRequired();
        }
        return var4;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return TEMPT_INGREDIENT.test(var0);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.5f;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isTame() && this.tickCount > 2400;
    }

    @Override
    protected void reassessTameGoals() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.goalSelector.removeGoal(this.avoidPlayersGoal);
        if (!this.isTame()) {
            this.goalSelector.addGoal(4, this.avoidPlayersGoal);
        }
    }

    @Override
    public boolean isSteppingCarefully() {
        return this.isCrouching() || super.isSteppingCarefully();
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityHuman selectedPlayer;
        private final EntityCat cat;

        public PathfinderGoalTemptChance(EntityCat var0, double var1, RecipeItemStack var3, boolean var4) {
            super(var0, var1, var3, var4);
            this.cat = var0;
        }

        @Override
        public void tick() {
            super.tick();
            if (this.selectedPlayer == null && this.mob.getRandom().nextInt(this.adjustedTickDelay(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.mob.getRandom().nextInt(this.adjustedTickDelay(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean canScare() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals(this.player)) {
                return false;
            }
            return super.canScare();
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.cat.isTame();
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityCat cat;
        @Nullable
        private EntityHuman ownerPlayer;
        @Nullable
        private BlockPosition goalPos;
        private int onBedTicks;

        public b(EntityCat var0) {
            this.cat = var0;
        }

        @Override
        public boolean canUse() {
            if (!this.cat.isTame()) {
                return false;
            }
            if (this.cat.isOrderedToSit()) {
                return false;
            }
            EntityLiving var0 = this.cat.getOwner();
            if (var0 instanceof EntityHuman) {
                this.ownerPlayer = (EntityHuman)var0;
                if (!var0.isSleeping()) {
                    return false;
                }
                if (this.cat.distanceToSqr(this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPosition var12 = this.ownerPlayer.blockPosition();
                IBlockData var2 = this.cat.level.getBlockState(var12);
                if (var2.is(TagsBlock.BEDS)) {
                    this.goalPos = var2.getOptionalValue(BlockBed.FACING).map(var1 -> var12.relative(var1.getOpposite())).orElseGet(() -> new BlockPosition(var12));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            List<EntityCat> var0 = this.cat.level.getEntitiesOfClass(EntityCat.class, new AxisAlignedBB(this.goalPos).inflate(2.0));
            for (EntityCat var2 : var0) {
                if (var2 == this.cat || !var2.isLying() && !var2.isRelaxStateOne()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return this.cat.isTame() && !this.cat.isOrderedToSit() && this.ownerPlayer != null && this.ownerPlayer.isSleeping() && this.goalPos != null && !this.spaceIsOccupied();
        }

        @Override
        public void start() {
            if (this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
            }
        }

        @Override
        public void stop() {
            this.cat.setLying(false);
            float var0 = this.cat.level.getTimeOfDay(1.0f);
            if (this.ownerPlayer.getSleepTimer() >= 100 && (double)var0 > 0.77 && (double)var0 < 0.8 && (double)this.cat.level.getRandom().nextFloat() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.setRelaxStateOne(false);
            this.cat.getNavigation().stop();
        }

        private void giveMorningGift() {
            RandomSource var0 = this.cat.getRandom();
            BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
            var1.set(this.cat.isLeashed() ? this.cat.getLeashHolder().blockPosition() : this.cat.blockPosition());
            this.cat.randomTeleport(var1.getX() + var0.nextInt(11) - 5, var1.getY() + var0.nextInt(5) - 2, var1.getZ() + var0.nextInt(11) - 5, false);
            var1.set(this.cat.blockPosition());
            LootTable var2 = this.cat.level.getServer().getLootTables().get(LootTables.CAT_MORNING_GIFT);
            LootTableInfo.Builder var3 = new LootTableInfo.Builder((WorldServer)this.cat.level).withParameter(LootContextParameters.ORIGIN, this.cat.position()).withParameter(LootContextParameters.THIS_ENTITY, this.cat).withRandom(var0);
            ObjectArrayList<ItemStack> var4 = var2.getRandomItems(var3.create(LootContextParameterSets.GIFT));
            for (ItemStack var6 : var4) {
                this.cat.level.addFreshEntity(new EntityItem(this.cat.level, (double)var1.getX() - (double)MathHelper.sin(this.cat.yBodyRot * ((float)Math.PI / 180)), var1.getY(), (double)var1.getZ() + (double)MathHelper.cos(this.cat.yBodyRot * ((float)Math.PI / 180)), var6));
            }
        }

        @Override
        public void tick() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
                if (this.cat.distanceToSqr(this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.adjustedTickDelay(16)) {
                        this.cat.setLying(true);
                        this.cat.setRelaxStateOne(false);
                    } else {
                        this.cat.lookAt(this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.setRelaxStateOne(true);
                    }
                } else {
                    this.cat.setLying(false);
                }
            }
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat cat;

        public a(EntityCat var0, Class<T> var1, float var2, double var3, double var5) {
            super(var0, var1, var2, var3, var5, IEntitySelector.NO_CREATIVE_OR_SPECTATOR::test);
            this.cat = var0;
        }

        @Override
        public boolean canUse() {
            return !this.cat.isTame() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return !this.cat.isTame() && super.canContinueToUse();
        }
    }
}

