/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class NavigationAbstract {
    private static final int MAX_TIME_RECOMPUTE = 20;
    private static final int STUCK_CHECK_INTERVAL = 100;
    private static final float STUCK_THRESHOLD_DISTANCE_FACTOR = 0.25f;
    protected final EntityInsentient mob;
    protected final World level;
    @Nullable
    protected PathEntity path;
    protected double speedModifier;
    protected int tick;
    protected int lastStuckCheck;
    protected Vec3D lastStuckCheckPos = Vec3D.ZERO;
    protected BaseBlockPosition timeoutCachedNode = BaseBlockPosition.ZERO;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 0.5f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected PathfinderAbstract nodeEvaluator;
    @Nullable
    private BlockPosition targetPos;
    private int reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private final Pathfinder pathFinder;
    private boolean isStuck;

    public NavigationAbstract(EntityInsentient var0, World var1) {
        this.mob = var0;
        this.level = var1;
        int var2 = MathHelper.floor(var0.getAttributeValue(GenericAttributes.FOLLOW_RANGE) * 16.0);
        this.pathFinder = this.createPathFinder(var2);
    }

    public void resetMaxVisitedNodesMultiplier() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    public void setMaxVisitedNodesMultiplier(float var0) {
        this.maxVisitedNodesMultiplier = var0;
    }

    @Nullable
    public BlockPosition getTargetPos() {
        return this.targetPos;
    }

    protected abstract Pathfinder createPathFinder(int var1);

    public void setSpeedModifier(double var0) {
        this.speedModifier = var0;
    }

    public void recomputePath() {
        if (this.level.getGameTime() - this.timeLastRecompute > 20L) {
            if (this.targetPos != null) {
                this.path = null;
                this.path = this.createPath(this.targetPos, this.reachRange);
                this.timeLastRecompute = this.level.getGameTime();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    @Nullable
    public final PathEntity createPath(double var0, double var2, double var4, int var6) {
        return this.createPath(new BlockPosition(var0, var2, var4), var6);
    }

    @Nullable
    public PathEntity createPath(Stream<BlockPosition> var0, int var1) {
        return this.createPath(var0.collect(Collectors.toSet()), 8, false, var1);
    }

    @Nullable
    public PathEntity createPath(Set<BlockPosition> var0, int var1) {
        return this.createPath(var0, 8, false, var1);
    }

    @Nullable
    public PathEntity createPath(BlockPosition var0, int var1) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1);
    }

    @Nullable
    public PathEntity createPath(BlockPosition var0, int var1, int var2) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1, var2);
    }

    @Nullable
    public PathEntity createPath(Entity var0, int var1) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)var0.blockPosition()), 16, true, var1);
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> var0, int var1, boolean var2, int var3) {
        return this.createPath(var0, var1, var2, var3, (float)this.mob.getAttributeValue(GenericAttributes.FOLLOW_RANGE));
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> var0, int var1, boolean var2, int var3, float var4) {
        if (var0.isEmpty()) {
            return null;
        }
        if (this.mob.getY() < (double)this.level.getMinBuildHeight()) {
            return null;
        }
        if (!this.canUpdatePath()) {
            return null;
        }
        if (this.path != null && !this.path.isDone() && var0.contains(this.targetPos)) {
            return this.path;
        }
        this.level.getProfiler().push("pathfind");
        BlockPosition var5 = var2 ? this.mob.blockPosition().above() : this.mob.blockPosition();
        int var6 = (int)(var4 + (float)var1);
        ChunkCache var7 = new ChunkCache(this.level, var5.offset(-var6, -var6, -var6), var5.offset(var6, var6, var6));
        PathEntity var8 = this.pathFinder.findPath(var7, this.mob, var0, var4, var3, this.maxVisitedNodesMultiplier);
        this.level.getProfiler().pop();
        if (var8 != null && var8.getTarget() != null) {
            this.targetPos = var8.getTarget();
            this.reachRange = var3;
            this.resetStuckTimeout();
        }
        return var8;
    }

    public boolean moveTo(double var0, double var2, double var4, double var6) {
        return this.moveTo(this.createPath(var0, var2, var4, 1), var6);
    }

    public boolean moveTo(Entity var0, double var1) {
        PathEntity var3 = this.createPath(var0, 1);
        return var3 != null && this.moveTo(var3, var1);
    }

    public boolean moveTo(@Nullable PathEntity var0, double var1) {
        if (var0 == null) {
            this.path = null;
            return false;
        }
        if (!var0.sameAs(this.path)) {
            this.path = var0;
        }
        if (this.isDone()) {
            return false;
        }
        this.trimPath();
        if (this.path.getNodeCount() <= 0) {
            return false;
        }
        this.speedModifier = var1;
        Vec3D var3 = this.getTempMobPos();
        this.lastStuckCheck = this.tick;
        this.lastStuckCheckPos = var3;
        return true;
    }

    @Nullable
    public PathEntity getPath() {
        return this.path;
    }

    public void tick() {
        Vec3D var0;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            var0 = this.getTempMobPos();
            Vec3D var1 = this.path.getNextEntityPos(this.mob);
            if (var0.y > var1.y && !this.mob.isOnGround() && MathHelper.floor(var0.x) == MathHelper.floor(var1.x) && MathHelper.floor(var0.z) == MathHelper.floor(var1.z)) {
                this.path.advance();
            }
        }
        PacketDebug.sendPathFindingPacket(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
        if (this.isDone()) {
            return;
        }
        var0 = this.path.getNextEntityPos(this.mob);
        this.mob.getMoveControl().setWantedPosition(var0.x, this.getGroundY(var0), var0.z, this.speedModifier);
    }

    protected double getGroundY(Vec3D var0) {
        BlockPosition var1 = new BlockPosition(var0);
        return this.level.getBlockState(var1.below()).isAir() ? var0.y : PathfinderNormal.getFloorLevel(this.level, var1);
    }

    protected void followThePath() {
        boolean var8;
        Vec3D var0 = this.getTempMobPos();
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        BlockPosition var1 = this.path.getNextNodePos();
        double var2 = Math.abs(this.mob.getX() - ((double)var1.getX() + 0.5));
        double var4 = Math.abs(this.mob.getY() - (double)var1.getY());
        double var6 = Math.abs(this.mob.getZ() - ((double)var1.getZ() + 0.5));
        boolean bl = var8 = var2 < (double)this.maxDistanceToWaypoint && var6 < (double)this.maxDistanceToWaypoint && var4 < 1.0;
        if (var8 || this.mob.canCutCorner(this.path.getNextNode().type) && this.shouldTargetNextNodeInDirection(var0)) {
            this.path.advance();
        }
        this.doStuckDetection(var0);
    }

    private boolean shouldTargetNextNodeInDirection(Vec3D var0) {
        boolean var10;
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        Vec3D var1 = Vec3D.atBottomCenterOf(this.path.getNextNodePos());
        if (!var0.closerThan(var1, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(var0, this.path.getNextEntityPos(this.mob))) {
            return true;
        }
        Vec3D var2 = Vec3D.atBottomCenterOf(this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        Vec3D var3 = var1.subtract(var0);
        Vec3D var4 = var2.subtract(var0);
        double var5 = var3.lengthSqr();
        double var7 = var4.lengthSqr();
        boolean var9 = var7 < var5;
        boolean bl = var10 = var5 < 0.5;
        if (var9 || var10) {
            Vec3D var11 = var3.normalize();
            Vec3D var12 = var4.normalize();
            return var12.dot(var11) < 0.0;
        }
        return false;
    }

    protected void doStuckDetection(Vec3D var0) {
        if (this.tick - this.lastStuckCheck > 100) {
            float var1 = this.mob.getSpeed() >= 1.0f ? this.mob.getSpeed() : this.mob.getSpeed() * this.mob.getSpeed();
            float var2 = var1 * 100.0f * 0.25f;
            if (var0.distanceToSqr(this.lastStuckCheckPos) < (double)(var2 * var2)) {
                this.isStuck = true;
                this.stop();
            } else {
                this.isStuck = false;
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = var0;
        }
        if (this.path != null && !this.path.isDone()) {
            BlockPosition var1 = this.path.getNextNodePos();
            long var2 = this.level.getGameTime();
            if (var1.equals(this.timeoutCachedNode)) {
                this.timeoutTimer += var2 - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = var1;
                double var4 = var0.distanceTo(Vec3D.atBottomCenterOf(this.timeoutCachedNode));
                double d2 = this.timeoutLimit = this.mob.getSpeed() > 0.0f ? var4 / (double)this.mob.getSpeed() * 20.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutPath();
            }
            this.lastTimeoutCheck = var2;
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = BaseBlockPosition.ZERO;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return this.path == null || this.path.isDone();
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.path = null;
    }

    protected abstract Vec3D getTempMobPos();

    protected abstract boolean canUpdatePath();

    protected boolean isInLiquid() {
        return this.mob.isInWaterOrBubble() || this.mob.isInLava();
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int var0 = 0; var0 < this.path.getNodeCount(); ++var0) {
            PathPoint var1 = this.path.getNode(var0);
            PathPoint var2 = var0 + 1 < this.path.getNodeCount() ? this.path.getNode(var0 + 1) : null;
            IBlockData var3 = this.level.getBlockState(new BlockPosition(var1.x, var1.y, var1.z));
            if (!var3.is(TagsBlock.CAULDRONS)) continue;
            this.path.replaceNode(var0, var1.cloneAndMove(var1.x, var1.y + 1, var1.z));
            if (var2 == null || var1.y < var2.y) continue;
            this.path.replaceNode(var0 + 1, var1.cloneAndMove(var2.x, var1.y + 1, var2.z));
        }
    }

    protected boolean canMoveDirectly(Vec3D var0, Vec3D var1) {
        return false;
    }

    protected static boolean isClearForMovementBetween(EntityInsentient var0, Vec3D var1, Vec3D var2, boolean var3) {
        Vec3D var4 = new Vec3D(var2.x, var2.y + (double)var0.getBbHeight() * 0.5, var2.z);
        return var0.level.clip(new RayTrace(var1, var4, RayTrace.BlockCollisionOption.COLLIDER, var3 ? RayTrace.FluidCollisionOption.ANY : RayTrace.FluidCollisionOption.NONE, var0)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public boolean isStableDestination(BlockPosition var0) {
        BlockPosition var1 = var0.below();
        return this.level.getBlockState(var1).isSolidRender(this.level, var1);
    }

    public PathfinderAbstract getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setCanFloat(boolean var0) {
        this.nodeEvaluator.setCanFloat(var0);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.canFloat();
    }

    public boolean shouldRecomputePath(BlockPosition var0) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path == null || this.path.isDone() || this.path.getNodeCount() == 0) {
            return false;
        }
        PathPoint var1 = this.path.getEndNode();
        Vec3D var2 = new Vec3D(((double)var1.x + this.mob.getX()) / 2.0, ((double)var1.y + this.mob.getY()) / 2.0, ((double)var1.z + this.mob.getZ()) / 2.0);
        return var0.closerToCenterThan(var2, this.path.getNodeCount() - this.path.getNextNodeIndex());
    }

    public float getMaxDistanceToWaypoint() {
        return this.maxDistanceToWaypoint;
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

