/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.EntityPerchable;

public class PathfinderGoalPerch
extends PathfinderGoal {
    private final EntityPerchable entity;
    private EntityPlayer owner;
    private boolean isSittingOnShoulder;

    public PathfinderGoalPerch(EntityPerchable var0) {
        this.entity = var0;
    }

    @Override
    public boolean canUse() {
        EntityPlayer var0 = (EntityPlayer)this.entity.getOwner();
        boolean var1 = var0 != null && !var0.isSpectator() && !var0.getAbilities().flying && !var0.isInWater() && !var0.isInPowderSnow;
        return !this.entity.isOrderedToSit() && var1 && this.entity.canSitOnShoulder();
    }

    @Override
    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    @Override
    public void start() {
        this.owner = (EntityPlayer)this.entity.getOwner();
        this.isSittingOnShoulder = false;
    }

    @Override
    public void tick() {
        if (this.isSittingOnShoulder || this.entity.isInSittingPose() || this.entity.isLeashed()) {
            return;
        }
        if (this.entity.getBoundingBox().intersects(this.owner.getBoundingBox())) {
            this.isSittingOnShoulder = this.entity.setEntityOnShoulder(this.owner);
        }
    }
}

