/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class BehaviorAttackTargetForget {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends EntityInsentient> BehaviorControl<E> create(BiConsumer<E, EntityLiving> var02) {
        return BehaviorAttackTargetForget.create(var0 -> false, var02, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create(Predicate<EntityLiving> var02) {
        return BehaviorAttackTargetForget.create(var02, (var0, var1) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create() {
        return BehaviorAttackTargetForget.create(var0 -> false, (var0, var1) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create(Predicate<EntityLiving> var0, BiConsumer<E, EntityLiving> var1, boolean var2) {
        return BehaviorBuilder.create((BehaviorBuilder.b<E> var3) -> var3.group(var3.present(MemoryModuleType.ATTACK_TARGET), var3.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)var3, (var4, var5) -> (var6, var7, var8) -> {
            EntityLiving var10 = (EntityLiving)var3.get(var4);
            if (!var7.canAttack(var10) || var2 && BehaviorAttackTargetForget.isTiredOfTryingToReachTarget(var7, var3.tryGet(var5)) || !var10.isAlive() || var10.level != var7.level || var0.test(var10)) {
                var1.accept(var7, var10);
                var4.erase();
                return true;
            }
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(EntityLiving var0, Optional<Long> var1) {
        return var1.isPresent() && var0.level.getGameTime() - var1.get() > 200L;
    }
}

