/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final DataWatcherObject<Float> DATA_RADIUS = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_COLOR = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_WAITING = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<ParticleParam> DATA_PARTICLE = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    private PotionRegistry potion = Potions.EMPTY;
    public List<MobEffect> effects = Lists.newArrayList();
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    private boolean fixedColor;
    public int durationOnUse;
    public float radiusOnUse;
    public float radiusPerTick;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private UUID ownerUUID;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> var0, World var1) {
        super(var0, var1);
        this.noPhysics = true;
    }

    public EntityAreaEffectCloud(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.AREA_EFFECT_CLOUD, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_COLOR, 0);
        this.getEntityData().define(DATA_RADIUS, Float.valueOf(3.0f));
        this.getEntityData().define(DATA_WAITING, false);
        this.getEntityData().define(DATA_PARTICLE, Particles.ENTITY_EFFECT);
    }

    public void setRadius(float var0) {
        if (!this.level.isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(MathHelper.clamp(var0, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotion(PotionRegistry var0) {
        this.potion = var0;
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    private void updateColor() {
        if (this.potion == Potions.EMPTY && this.effects.isEmpty()) {
            this.getEntityData().set(DATA_COLOR, 0);
        } else {
            this.getEntityData().set(DATA_COLOR, PotionUtil.getColor(PotionUtil.getAllEffects(this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffect var0) {
        this.effects.add(var0);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return this.getEntityData().get(DATA_COLOR);
    }

    public void setFixedColor(int var0) {
        this.fixedColor = true;
        this.getEntityData().set(DATA_COLOR, var0);
    }

    public ParticleParam getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleParam var0) {
        this.getEntityData().set(DATA_PARTICLE, var0);
    }

    protected void setWaiting(boolean var0) {
        this.getEntityData().set(DATA_WAITING, var0);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int var0) {
        this.duration = var0;
    }

    @Override
    public void tick() {
        block20: {
            ArrayList var3;
            float var1;
            block21: {
                boolean var2;
                boolean var02;
                block19: {
                    float var4;
                    int var32;
                    super.tick();
                    var02 = this.isWaiting();
                    var1 = this.getRadius();
                    if (!this.level.isClientSide) break block19;
                    if (var02 && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleParam var22 = this.getParticle();
                    if (var02) {
                        var32 = 2;
                        var4 = 0.2f;
                    } else {
                        var32 = MathHelper.ceil((float)Math.PI * var1 * var1);
                        var4 = var1;
                    }
                    for (int var5 = 0; var5 < var32; ++var5) {
                        double var18;
                        double var16;
                        double var14;
                        float var6 = this.random.nextFloat() * ((float)Math.PI * 2);
                        float var7 = MathHelper.sqrt(this.random.nextFloat()) * var4;
                        double var8 = this.getX() + (double)(MathHelper.cos(var6) * var7);
                        double var10 = this.getY();
                        double var12 = this.getZ() + (double)(MathHelper.sin(var6) * var7);
                        if (var22.getType() == Particles.ENTITY_EFFECT) {
                            int var20 = var02 && this.random.nextBoolean() ? 0xFFFFFF : this.getColor();
                            var14 = (float)(var20 >> 16 & 0xFF) / 255.0f;
                            var16 = (float)(var20 >> 8 & 0xFF) / 255.0f;
                            var18 = (float)(var20 & 0xFF) / 255.0f;
                        } else if (var02) {
                            var14 = 0.0;
                            var16 = 0.0;
                            var18 = 0.0;
                        } else {
                            var14 = (0.5 - this.random.nextDouble()) * 0.15;
                            var16 = 0.01f;
                            var18 = (0.5 - this.random.nextDouble()) * 0.15;
                        }
                        this.level.addAlwaysVisibleParticle(var22, var8, var10, var12, var14, var16, var18);
                    }
                    break block20;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard();
                    return;
                }
                boolean bl = var2 = this.tickCount < this.waitTime;
                if (var02 != var2) {
                    this.setWaiting(var2);
                }
                if (var2) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((var1 += this.radiusPerTick) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(var1);
                }
                if (this.tickCount % 5 != 0) break block20;
                this.victims.entrySet().removeIf(var0 -> this.tickCount >= (Integer)var0.getValue());
                var3 = Lists.newArrayList();
                for (MobEffect var5 : this.potion.getEffects()) {
                    var3.add(new MobEffect(var5.getEffect(), var5.getDuration() / 4, var5.getAmplifier(), var5.isAmbient(), var5.isVisible()));
                }
                var3.addAll(this.effects);
                if (!var3.isEmpty()) break block21;
                this.victims.clear();
                break block20;
            }
            List<EntityLiving> var4 = this.level.getEntitiesOfClass(EntityLiving.class, this.getBoundingBox());
            if (var4.isEmpty()) break block20;
            for (EntityLiving var6 : var4) {
                double var9;
                double var7;
                double var11;
                if (this.victims.containsKey(var6) || !var6.isAffectedByPotions() || !((var11 = (var7 = var6.getX() - this.getX()) * var7 + (var9 = var6.getZ() - this.getZ()) * var9) <= (double)(var1 * var1))) continue;
                this.victims.put(var6, this.tickCount + this.reapplicationDelay);
                for (MobEffect var14 : var3) {
                    if (var14.getEffect().isInstantenous()) {
                        var14.getEffect().applyInstantenousEffect(this, this.getOwner(), var6, var14.getAmplifier(), 0.5);
                        continue;
                    }
                    var6.addEffect(new MobEffect(var14), this);
                }
                if (this.radiusOnUse != 0.0f) {
                    if ((var1 += this.radiusOnUse) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(var1);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.discard();
                return;
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float var0) {
        this.radiusOnUse = var0;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float var0) {
        this.radiusPerTick = var0;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int var0) {
        this.durationOnUse = var0;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int var0) {
        this.waitTime = var0;
    }

    public void setOwner(@Nullable EntityLiving var0) {
        this.owner = var0;
        this.ownerUUID = var0 == null ? null : var0.getUUID();
    }

    @Nullable
    public EntityLiving getOwner() {
        Entity var0;
        if (this.owner == null && this.ownerUUID != null && this.level instanceof WorldServer && (var0 = ((WorldServer)this.level).getEntity(this.ownerUUID)) instanceof EntityLiving) {
            this.owner = (EntityLiving)var0;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.tickCount = var0.getInt("Age");
        this.duration = var0.getInt("Duration");
        this.waitTime = var0.getInt("WaitTime");
        this.reapplicationDelay = var0.getInt("ReapplicationDelay");
        this.durationOnUse = var0.getInt("DurationOnUse");
        this.radiusOnUse = var0.getFloat("RadiusOnUse");
        this.radiusPerTick = var0.getFloat("RadiusPerTick");
        this.setRadius(var0.getFloat("Radius"));
        if (var0.hasUUID("Owner")) {
            this.ownerUUID = var0.getUUID("Owner");
        }
        if (var0.contains("Particle", 8)) {
            try {
                this.setParticle(ArgumentParticle.readParticle(new StringReader(var0.getString("Particle")), BuiltInRegistries.PARTICLE_TYPE.asLookup()));
            }
            catch (CommandSyntaxException var1) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)var0.getString("Particle"), (Object)var1);
            }
        }
        if (var0.contains("Color", 99)) {
            this.setFixedColor(var0.getInt("Color"));
        }
        if (var0.contains("Potion", 8)) {
            this.setPotion(PotionUtil.getPotion(var0));
        }
        if (var0.contains("Effects", 9)) {
            NBTTagList var1 = var0.getList("Effects", 10);
            this.effects.clear();
            for (int var2 = 0; var2 < var1.size(); ++var2) {
                MobEffect var3 = MobEffect.load(var1.getCompound(var2));
                if (var3 == null) continue;
                this.addEffect(var3);
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putInt("Age", this.tickCount);
        var0.putInt("Duration", this.duration);
        var0.putInt("WaitTime", this.waitTime);
        var0.putInt("ReapplicationDelay", this.reapplicationDelay);
        var0.putInt("DurationOnUse", this.durationOnUse);
        var0.putFloat("RadiusOnUse", this.radiusOnUse);
        var0.putFloat("RadiusPerTick", this.radiusPerTick);
        var0.putFloat("Radius", this.getRadius());
        var0.putString("Particle", this.getParticle().writeToString());
        if (this.ownerUUID != null) {
            var0.putUUID("Owner", this.ownerUUID);
        }
        if (this.fixedColor) {
            var0.putInt("Color", this.getColor());
        }
        if (this.potion != Potions.EMPTY) {
            var0.putString("Potion", BuiltInRegistries.POTION.getKey(this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList var1 = new NBTTagList();
            for (MobEffect var3 : this.effects) {
                var1.add(var3.save(new NBTTagCompound()));
            }
            var0.put("Effects", var1);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_RADIUS.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    public PotionRegistry getPotion() {
        return this.potion;
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return EntitySize.scalable(this.getRadius() * 2.0f, 0.5f);
    }
}

