/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;

public class MobEffectList {
    private final Map<AttributeBase, AttributeModifier> attributeModifiers = Maps.newHashMap();
    private final MobEffectInfo category;
    private final int color;
    @Nullable
    private String descriptionId;
    private Supplier<MobEffect.a> factorDataFactory = () -> null;

    @Nullable
    public static MobEffectList byId(int var0) {
        return (MobEffectList)BuiltInRegistries.MOB_EFFECT.byId(var0);
    }

    public static int getId(MobEffectList var0) {
        return BuiltInRegistries.MOB_EFFECT.getId(var0);
    }

    public static int getIdFromNullable(@Nullable MobEffectList var0) {
        return BuiltInRegistries.MOB_EFFECT.getId(var0);
    }

    protected MobEffectList(MobEffectInfo var0, int var1) {
        this.category = var0;
        this.color = var1;
    }

    public Optional<MobEffect.a> createFactorData() {
        return Optional.ofNullable(this.factorDataFactory.get());
    }

    public void applyEffectTick(EntityLiving var0, int var1) {
        if (this == MobEffects.REGENERATION) {
            if (var0.getHealth() < var0.getMaxHealth()) {
                var0.heal(1.0f);
            }
        } else if (this == MobEffects.POISON) {
            if (var0.getHealth() > 1.0f) {
                var0.hurt(DamageSource.MAGIC, 1.0f);
            }
        } else if (this == MobEffects.WITHER) {
            var0.hurt(DamageSource.WITHER, 1.0f);
        } else if (this == MobEffects.HUNGER && var0 instanceof EntityHuman) {
            ((EntityHuman)var0).causeFoodExhaustion(0.005f * (float)(var1 + 1));
        } else if (this == MobEffects.SATURATION && var0 instanceof EntityHuman) {
            if (!var0.level.isClientSide) {
                ((EntityHuman)var0).getFoodData().eat(var1 + 1, 1.0f);
            }
        } else if (this == MobEffects.HEAL && !var0.isInvertedHealAndHarm() || this == MobEffects.HARM && var0.isInvertedHealAndHarm()) {
            var0.heal(Math.max(4 << var1, 0));
        } else if (this == MobEffects.HARM && !var0.isInvertedHealAndHarm() || this == MobEffects.HEAL && var0.isInvertedHealAndHarm()) {
            var0.hurt(DamageSource.MAGIC, 6 << var1);
        }
    }

    public void applyInstantenousEffect(@Nullable Entity var0, @Nullable Entity var1, EntityLiving var2, int var3, double var4) {
        if (this == MobEffects.HEAL && !var2.isInvertedHealAndHarm() || this == MobEffects.HARM && var2.isInvertedHealAndHarm()) {
            int var6 = (int)(var4 * (double)(4 << var3) + 0.5);
            var2.heal(var6);
        } else if (this == MobEffects.HARM && !var2.isInvertedHealAndHarm() || this == MobEffects.HEAL && var2.isInvertedHealAndHarm()) {
            int var6 = (int)(var4 * (double)(6 << var3) + 0.5);
            if (var0 == null) {
                var2.hurt(DamageSource.MAGIC, var6);
            } else {
                var2.hurt(DamageSource.indirectMagic(var0, var1), var6);
            }
        } else {
            this.applyEffectTick(var2, var3);
        }
    }

    public boolean isDurationEffectTick(int var0, int var1) {
        if (this == MobEffects.REGENERATION) {
            int var2 = 50 >> var1;
            if (var2 > 0) {
                return var0 % var2 == 0;
            }
            return true;
        }
        if (this == MobEffects.POISON) {
            int var2 = 25 >> var1;
            if (var2 > 0) {
                return var0 % var2 == 0;
            }
            return true;
        }
        if (this == MobEffects.WITHER) {
            int var2 = 40 >> var1;
            if (var2 > 0) {
                return var0 % var2 == 0;
            }
            return true;
        }
        return this == MobEffects.HUNGER;
    }

    public boolean isInstantenous() {
        return false;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("effect", BuiltInRegistries.MOB_EFFECT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable(this.getDescriptionId());
    }

    public MobEffectInfo getCategory() {
        return this.category;
    }

    public int getColor() {
        return this.color;
    }

    public MobEffectList addAttributeModifier(AttributeBase var0, String var1, double var2, AttributeModifier.Operation var4) {
        AttributeModifier var5 = new AttributeModifier(UUID.fromString(var1), this::getDescriptionId, var2, var4);
        this.attributeModifiers.put(var0, var5);
        return this;
    }

    public MobEffectList setFactorDataFactory(Supplier<MobEffect.a> var0) {
        this.factorDataFactory = var0;
        return this;
    }

    public Map<AttributeBase, AttributeModifier> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public void removeAttributeModifiers(EntityLiving var0, AttributeMapBase var1, int var2) {
        for (Map.Entry<AttributeBase, AttributeModifier> var4 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var5 = var1.getInstance(var4.getKey());
            if (var5 == null) continue;
            var5.removeModifier(var4.getValue());
        }
    }

    public void addAttributeModifiers(EntityLiving var0, AttributeMapBase var1, int var2) {
        for (Map.Entry<AttributeBase, AttributeModifier> var4 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var5 = var1.getInstance(var4.getKey());
            if (var5 == null) continue;
            AttributeModifier var6 = var4.getValue();
            var5.removeModifier(var6);
            var5.addPermanentModifier(new AttributeModifier(var6.getId(), this.getDescriptionId() + " " + var2, this.getAttributeModifierValue(var2, var6), var6.getOperation()));
        }
    }

    public double getAttributeModifierValue(int var0, AttributeModifier var1) {
        return var1.getAmount() * (double)(var0 + 1);
    }

    public boolean isBeneficial() {
        return this.category == MobEffectInfo.BENEFICIAL;
    }
}

