/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.SampledFloat;

public abstract class FloatProvider
implements SampledFloat {
    private static final Codec<Either<Float, FloatProvider>> CONSTANT_OR_DISPATCH_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)BuiltInRegistries.FLOAT_PROVIDER_TYPE.byNameCodec().dispatch(FloatProvider::getType, FloatProviderType::codec));
    public static final Codec<FloatProvider> CODEC = CONSTANT_OR_DISPATCH_CODEC.xmap(var02 -> (FloatProvider)var02.map(ConstantFloat::of, var0 -> var0), var0 -> var0.getType() == FloatProviderType.CONSTANT ? Either.left((Object)Float.valueOf(((ConstantFloat)var0).getValue())) : Either.right((Object)var0));

    public static Codec<FloatProvider> codec(float var0, float var1) {
        Function<FloatProvider, DataResult> var22 = var2 -> {
            if (var2.getMinValue() < var0) {
                return DataResult.error((String)("Value provider too low: " + var0 + " [" + var2.getMinValue() + "-" + var2.getMaxValue() + "]"));
            }
            if (var2.getMaxValue() > var1) {
                return DataResult.error((String)("Value provider too high: " + var1 + " [" + var2.getMinValue() + "-" + var2.getMaxValue() + "]"));
            }
            return DataResult.success((Object)var2);
        };
        return CODEC.flatXmap(var22, var22);
    }

    public abstract float getMinValue();

    public abstract float getMaxValue();

    public abstract FloatProviderType<?> getType();
}

