/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;

public final class NetworkPacketSummary {
    private final a totalPacketCountAndSize;
    private final List<Pair<b, a>> largestSizeContributors;
    private final Duration recordingDuration;

    public NetworkPacketSummary(Duration var0, List<Pair<b, a>> var1) {
        this.recordingDuration = var0;
        this.totalPacketCountAndSize = var1.stream().map(Pair::getSecond).reduce(a::add).orElseGet(() -> new a(0L, 0L));
        this.largestSizeContributors = var1.stream().sorted(Comparator.comparing(Pair::getSecond, a.SIZE_THEN_COUNT)).limit(10L).toList();
    }

    public double getCountsPerSecond() {
        return (double)this.totalPacketCountAndSize.totalCount / (double)this.recordingDuration.getSeconds();
    }

    public double getSizePerSecond() {
        return (double)this.totalPacketCountAndSize.totalSize / (double)this.recordingDuration.getSeconds();
    }

    public long getTotalCount() {
        return this.totalPacketCountAndSize.totalCount;
    }

    public long getTotalSize() {
        return this.totalPacketCountAndSize.totalSize;
    }

    public List<Pair<b, a>> largestSizeContributors() {
        return this.largestSizeContributors;
    }

    public static final class a
    extends Record {
        final long totalCount;
        final long totalSize;
        static final Comparator<a> SIZE_THEN_COUNT = Comparator.comparing(a::totalSize).thenComparing(a::totalCount).reversed();

        public a(long var0, long var2) {
            this.totalCount = var0;
            this.totalSize = var2;
        }

        a add(a var0) {
            return new a(this.totalCount + var0.totalCount, this.totalSize + var0.totalSize);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "totalCount;totalSize", "totalCount", "totalSize"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "totalCount;totalSize", "totalCount", "totalSize"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "totalCount;totalSize", "totalCount", "totalSize"}, this, var0);
        }

        public long totalCount() {
            return this.totalCount;
        }

        public long totalSize() {
            return this.totalSize;
        }
    }

    public record b(EnumProtocolDirection direction, int protocolId, int packetId) {
        private static final Map<b, String> PACKET_NAME_BY_ID;

        public String packetName() {
            return PACKET_NAME_BY_ID.getOrDefault(this, "unknown");
        }

        public static b from(RecordedEvent var0) {
            return new b(var0.getEventType().getName().equals("minecraft.PacketSent") ? EnumProtocolDirection.CLIENTBOUND : EnumProtocolDirection.SERVERBOUND, var0.getInt("protocolId"), var0.getInt("packetId"));
        }

        static {
            ImmutableMap.Builder var0 = ImmutableMap.builder();
            for (EnumProtocol var42 : EnumProtocol.values()) {
                for (EnumProtocolDirection var8 : EnumProtocolDirection.values()) {
                    Int2ObjectMap<Class<? extends Packet<?>>> var9 = var42.getPacketsByIds(var8);
                    var9.forEach((var3, var4) -> var0.put((Object)new b(var8, var42.getId(), (int)var3), (Object)var4.getSimpleName()));
                }
            }
            PACKET_NAME_BY_ID = var0.build();
        }
    }
}

