/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class SimpleRenameFix
extends DataFix {
    private final String fixerName;
    private final Map<String, String> nameMapping;
    private final DSL.TypeReference typeReference;

    public SimpleRenameFix(Schema var0, DSL.TypeReference var1, Map<String, String> var2) {
        this(var0, var1, var1.typeName() + "-renames at version: " + var0.getVersionKey(), var2);
    }

    public SimpleRenameFix(Schema var0, DSL.TypeReference var1, String var2, Map<String, String> var3) {
        super(var0, false);
        this.nameMapping = var3;
        this.fixerName = var2;
        this.typeReference = var1;
    }

    protected TypeRewriteRule makeRule() {
        Type var02 = DSL.named((String)this.typeReference.typeName(), DataConverterSchemaNamed.namespacedString());
        if (!Objects.equals(var02, this.getInputSchema().getType(this.typeReference))) {
            throw new IllegalStateException("\"" + this.typeReference.typeName() + "\" type is not what was expected.");
        }
        return this.fixTypeEverywhere(this.fixerName, var02, var0 -> var02 -> var02.mapSecond(var0 -> this.nameMapping.getOrDefault(var0, (String)var0)));
    }
}

