/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryID;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class ChunkConverterPalette
extends DataFix {
    private static final int NORTH_WEST_MASK = 128;
    private static final int WEST_MASK = 64;
    private static final int SOUTH_WEST_MASK = 32;
    private static final int SOUTH_MASK = 16;
    private static final int SOUTH_EAST_MASK = 8;
    private static final int EAST_MASK = 4;
    private static final int NORTH_EAST_MASK = 2;
    private static final int NORTH_MASK = 1;
    static final Logger LOGGER = LogUtils.getLogger();
    static final BitSet VIRTUAL = new BitSet(256);
    static final BitSet FIX = new BitSet(256);
    static final Dynamic<?> PUMPKIN = DataConverterFlattenData.parse("{Name:'minecraft:pumpkin'}");
    static final Dynamic<?> SNOWY_PODZOL = DataConverterFlattenData.parse("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
    static final Dynamic<?> SNOWY_GRASS = DataConverterFlattenData.parse("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
    static final Dynamic<?> SNOWY_MYCELIUM = DataConverterFlattenData.parse("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
    static final Dynamic<?> UPPER_SUNFLOWER = DataConverterFlattenData.parse("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_LILAC = DataConverterFlattenData.parse("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_TALL_GRASS = DataConverterFlattenData.parse("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_LARGE_FERN = DataConverterFlattenData.parse("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_ROSE_BUSH = DataConverterFlattenData.parse("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_PEONY = DataConverterFlattenData.parse("{Name:'minecraft:peony',Properties:{half:'upper'}}");
    static final Map<String, Dynamic<?>> FLOWER_POT_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        var0.put("minecraft:air0", DataConverterFlattenData.parse("{Name:'minecraft:flower_pot'}"));
        var0.put("minecraft:red_flower0", DataConverterFlattenData.parse("{Name:'minecraft:potted_poppy'}"));
        var0.put("minecraft:red_flower1", DataConverterFlattenData.parse("{Name:'minecraft:potted_blue_orchid'}"));
        var0.put("minecraft:red_flower2", DataConverterFlattenData.parse("{Name:'minecraft:potted_allium'}"));
        var0.put("minecraft:red_flower3", DataConverterFlattenData.parse("{Name:'minecraft:potted_azure_bluet'}"));
        var0.put("minecraft:red_flower4", DataConverterFlattenData.parse("{Name:'minecraft:potted_red_tulip'}"));
        var0.put("minecraft:red_flower5", DataConverterFlattenData.parse("{Name:'minecraft:potted_orange_tulip'}"));
        var0.put("minecraft:red_flower6", DataConverterFlattenData.parse("{Name:'minecraft:potted_white_tulip'}"));
        var0.put("minecraft:red_flower7", DataConverterFlattenData.parse("{Name:'minecraft:potted_pink_tulip'}"));
        var0.put("minecraft:red_flower8", DataConverterFlattenData.parse("{Name:'minecraft:potted_oxeye_daisy'}"));
        var0.put("minecraft:yellow_flower0", DataConverterFlattenData.parse("{Name:'minecraft:potted_dandelion'}"));
        var0.put("minecraft:sapling0", DataConverterFlattenData.parse("{Name:'minecraft:potted_oak_sapling'}"));
        var0.put("minecraft:sapling1", DataConverterFlattenData.parse("{Name:'minecraft:potted_spruce_sapling'}"));
        var0.put("minecraft:sapling2", DataConverterFlattenData.parse("{Name:'minecraft:potted_birch_sapling'}"));
        var0.put("minecraft:sapling3", DataConverterFlattenData.parse("{Name:'minecraft:potted_jungle_sapling'}"));
        var0.put("minecraft:sapling4", DataConverterFlattenData.parse("{Name:'minecraft:potted_acacia_sapling'}"));
        var0.put("minecraft:sapling5", DataConverterFlattenData.parse("{Name:'minecraft:potted_dark_oak_sapling'}"));
        var0.put("minecraft:red_mushroom0", DataConverterFlattenData.parse("{Name:'minecraft:potted_red_mushroom'}"));
        var0.put("minecraft:brown_mushroom0", DataConverterFlattenData.parse("{Name:'minecraft:potted_brown_mushroom'}"));
        var0.put("minecraft:deadbush0", DataConverterFlattenData.parse("{Name:'minecraft:potted_dead_bush'}"));
        var0.put("minecraft:tallgrass2", DataConverterFlattenData.parse("{Name:'minecraft:potted_fern'}"));
        var0.put("minecraft:cactus0", DataConverterFlattenData.getTag(2240));
    });
    static final Map<String, Dynamic<?>> SKULL_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        ChunkConverterPalette.mapSkull(var0, 0, "skeleton", "skull");
        ChunkConverterPalette.mapSkull(var0, 1, "wither_skeleton", "skull");
        ChunkConverterPalette.mapSkull(var0, 2, "zombie", "head");
        ChunkConverterPalette.mapSkull(var0, 3, "player", "head");
        ChunkConverterPalette.mapSkull(var0, 4, "creeper", "head");
        ChunkConverterPalette.mapSkull(var0, 5, "dragon", "head");
    });
    static final Map<String, Dynamic<?>> DOOR_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        ChunkConverterPalette.mapDoor(var0, "oak_door", 1024);
        ChunkConverterPalette.mapDoor(var0, "iron_door", 1136);
        ChunkConverterPalette.mapDoor(var0, "spruce_door", 3088);
        ChunkConverterPalette.mapDoor(var0, "birch_door", 3104);
        ChunkConverterPalette.mapDoor(var0, "jungle_door", 3120);
        ChunkConverterPalette.mapDoor(var0, "acacia_door", 3136);
        ChunkConverterPalette.mapDoor(var0, "dark_oak_door", 3152);
    });
    static final Map<String, Dynamic<?>> NOTE_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        for (int var1 = 0; var1 < 26; ++var1) {
            var0.put("true" + var1, DataConverterFlattenData.parse("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + var1 + "'}}"));
            var0.put("false" + var1, DataConverterFlattenData.parse("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + var1 + "'}}"));
        }
    });
    private static final Int2ObjectMap<String> DYE_COLOR_MAP = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), var0 -> {
        var0.put(0, (Object)"white");
        var0.put(1, (Object)"orange");
        var0.put(2, (Object)"magenta");
        var0.put(3, (Object)"light_blue");
        var0.put(4, (Object)"yellow");
        var0.put(5, (Object)"lime");
        var0.put(6, (Object)"pink");
        var0.put(7, (Object)"gray");
        var0.put(8, (Object)"light_gray");
        var0.put(9, (Object)"cyan");
        var0.put(10, (Object)"purple");
        var0.put(11, (Object)"blue");
        var0.put(12, (Object)"brown");
        var0.put(13, (Object)"green");
        var0.put(14, (Object)"red");
        var0.put(15, (Object)"black");
    });
    static final Map<String, Dynamic<?>> BED_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        for (Int2ObjectMap.Entry var2 : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(var2.getValue(), "red")) continue;
            ChunkConverterPalette.addBeds(var0, var2.getIntKey(), (String)var2.getValue());
        }
    });
    static final Map<String, Dynamic<?>> BANNER_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        for (Int2ObjectMap.Entry var2 : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(var2.getValue(), "white")) continue;
            ChunkConverterPalette.addBanners(var0, 15 - var2.getIntKey(), (String)var2.getValue());
        }
    });
    static final Dynamic<?> AIR;
    private static final int SIZE = 4096;

    public ChunkConverterPalette(Schema var0, boolean var1) {
        super(var0, var1);
    }

    private static void mapSkull(Map<String, Dynamic<?>> var0, int var1, String var2, String var3) {
        var0.put(var1 + "north", DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_" + var3 + "',Properties:{facing:'north'}}"));
        var0.put(var1 + "east", DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_" + var3 + "',Properties:{facing:'east'}}"));
        var0.put(var1 + "south", DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_" + var3 + "',Properties:{facing:'south'}}"));
        var0.put(var1 + "west", DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_" + var3 + "',Properties:{facing:'west'}}"));
        for (int var4 = 0; var4 < 16; ++var4) {
            var0.put("" + var1 + var4, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_" + var3 + "',Properties:{rotation:'" + var4 + "'}}"));
        }
    }

    private static void mapDoor(Map<String, Dynamic<?>> var0, String var1, int var2) {
        var0.put("minecraft:" + var1 + "eastlowerleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "eastlowerleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "eastlowerlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "eastlowerlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "eastlowerrightfalsefalse", DataConverterFlattenData.getTag(var2));
        var0.put("minecraft:" + var1 + "eastlowerrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "eastlowerrighttruefalse", DataConverterFlattenData.getTag(var2 + 4));
        var0.put("minecraft:" + var1 + "eastlowerrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "eastupperleftfalsefalse", DataConverterFlattenData.getTag(var2 + 8));
        var0.put("minecraft:" + var1 + "eastupperleftfalsetrue", DataConverterFlattenData.getTag(var2 + 10));
        var0.put("minecraft:" + var1 + "eastupperlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "eastupperlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "eastupperrightfalsefalse", DataConverterFlattenData.getTag(var2 + 9));
        var0.put("minecraft:" + var1 + "eastupperrightfalsetrue", DataConverterFlattenData.getTag(var2 + 11));
        var0.put("minecraft:" + var1 + "eastupperrighttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "eastupperrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northlowerleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northlowerleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northlowerlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northlowerlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northlowerrightfalsefalse", DataConverterFlattenData.getTag(var2 + 3));
        var0.put("minecraft:" + var1 + "northlowerrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northlowerrighttruefalse", DataConverterFlattenData.getTag(var2 + 7));
        var0.put("minecraft:" + var1 + "northlowerrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northupperleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northupperleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northupperlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northupperlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northupperrightfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northupperrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "northupperrighttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "northupperrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southlowerleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southlowerleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southlowerlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southlowerlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southlowerrightfalsefalse", DataConverterFlattenData.getTag(var2 + 1));
        var0.put("minecraft:" + var1 + "southlowerrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southlowerrighttruefalse", DataConverterFlattenData.getTag(var2 + 5));
        var0.put("minecraft:" + var1 + "southlowerrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southupperleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southupperleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southupperlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southupperlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southupperrightfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southupperrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "southupperrighttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "southupperrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westlowerleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westlowerleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westlowerlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westlowerlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westlowerrightfalsefalse", DataConverterFlattenData.getTag(var2 + 2));
        var0.put("minecraft:" + var1 + "westlowerrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westlowerrighttruefalse", DataConverterFlattenData.getTag(var2 + 6));
        var0.put("minecraft:" + var1 + "westlowerrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westupperleftfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westupperleftfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westupperlefttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westupperlefttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westupperrightfalsefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westupperrightfalsetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        var0.put("minecraft:" + var1 + "westupperrighttruefalse", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        var0.put("minecraft:" + var1 + "westupperrighttruetrue", DataConverterFlattenData.parse("{Name:'minecraft:" + var1 + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void addBeds(Map<String, Dynamic<?>> var0, int var1, String var2) {
        var0.put("southfalsefoot" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        var0.put("westfalsefoot" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        var0.put("northfalsefoot" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        var0.put("eastfalsefoot" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        var0.put("southfalsehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        var0.put("westfalsehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        var0.put("northfalsehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        var0.put("eastfalsehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        var0.put("southtruehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        var0.put("westtruehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        var0.put("northtruehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        var0.put("easttruehead" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void addBanners(Map<String, Dynamic<?>> var0, int var1, String var2) {
        for (int var3 = 0; var3 < 16; ++var3) {
            var0.put(var3 + "_" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_banner',Properties:{rotation:'" + var3 + "'}}"));
        }
        var0.put("north_" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_banner',Properties:{facing:'north'}}"));
        var0.put("south_" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_banner',Properties:{facing:'south'}}"));
        var0.put("west_" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_banner',Properties:{facing:'west'}}"));
        var0.put("east_" + var1, DataConverterFlattenData.parse("{Name:'minecraft:" + var2 + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public static String getName(Dynamic<?> var0) {
        return var0.get("Name").asString("");
    }

    public static String getProperty(Dynamic<?> var0, String var1) {
        return var0.get("Properties").get(var1).asString("");
    }

    public static int idFor(RegistryID<Dynamic<?>> var0, Dynamic<?> var1) {
        int var2 = var0.getId(var1);
        if (var2 == -1) {
            var2 = var0.add(var1);
        }
        return var2;
    }

    private Dynamic<?> fix(Dynamic<?> var0) {
        Optional var1 = var0.get("Level").result();
        if (var1.isPresent() && ((Dynamic)var1.get()).get("Sections").asStreamOpt().result().isPresent()) {
            return var0.set("Level", new d((Dynamic)var1.get()).write());
        }
        return var0;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.CHUNK);
        return this.writeFixAndRead("ChunkPalettedStorageFix", var0, var1, this::fix);
    }

    public static int getSideMask(boolean var0, boolean var1, boolean var2, boolean var3) {
        int var4 = 0;
        if (var2) {
            var4 = var1 ? (var4 |= 2) : (var0 ? (var4 |= 0x80) : (var4 |= 1));
        } else if (var3) {
            var4 = var0 ? (var4 |= 0x20) : (var1 ? (var4 |= 8) : (var4 |= 0x10));
        } else if (var1) {
            var4 |= 4;
        } else if (var0) {
            var4 |= 0x40;
        }
        return var4;
    }

    static {
        FIX.set(2);
        FIX.set(3);
        FIX.set(110);
        FIX.set(140);
        FIX.set(144);
        FIX.set(25);
        FIX.set(86);
        FIX.set(26);
        FIX.set(176);
        FIX.set(177);
        FIX.set(175);
        FIX.set(64);
        FIX.set(71);
        FIX.set(193);
        FIX.set(194);
        FIX.set(195);
        FIX.set(196);
        FIX.set(197);
        VIRTUAL.set(54);
        VIRTUAL.set(146);
        VIRTUAL.set(25);
        VIRTUAL.set(26);
        VIRTUAL.set(51);
        VIRTUAL.set(53);
        VIRTUAL.set(67);
        VIRTUAL.set(108);
        VIRTUAL.set(109);
        VIRTUAL.set(114);
        VIRTUAL.set(128);
        VIRTUAL.set(134);
        VIRTUAL.set(135);
        VIRTUAL.set(136);
        VIRTUAL.set(156);
        VIRTUAL.set(163);
        VIRTUAL.set(164);
        VIRTUAL.set(180);
        VIRTUAL.set(203);
        VIRTUAL.set(55);
        VIRTUAL.set(85);
        VIRTUAL.set(113);
        VIRTUAL.set(188);
        VIRTUAL.set(189);
        VIRTUAL.set(190);
        VIRTUAL.set(191);
        VIRTUAL.set(192);
        VIRTUAL.set(93);
        VIRTUAL.set(94);
        VIRTUAL.set(101);
        VIRTUAL.set(102);
        VIRTUAL.set(160);
        VIRTUAL.set(106);
        VIRTUAL.set(107);
        VIRTUAL.set(183);
        VIRTUAL.set(184);
        VIRTUAL.set(185);
        VIRTUAL.set(186);
        VIRTUAL.set(187);
        VIRTUAL.set(132);
        VIRTUAL.set(139);
        VIRTUAL.set(199);
        AIR = DataConverterFlattenData.getTag(0);
    }

    static final class d {
        private int sides;
        private final c[] sections = new c[16];
        private final Dynamic<?> level;
        private final int x;
        private final int z;
        private final Int2ObjectMap<Dynamic<?>> blockEntities = new Int2ObjectLinkedOpenHashMap(16);

        public d(Dynamic<?> var0) {
            this.level = var0;
            this.x = var0.get("xPos").asInt(0) << 4;
            this.z = var0.get("zPos").asInt(0) << 4;
            var0.get("TileEntities").asStreamOpt().result().ifPresent(var02 -> var02.forEach(var0 -> {
                int var3;
                int var1 = var0.get("x").asInt(0) - this.x & 0xF;
                int var2 = var0.get("y").asInt(0);
                int var4 = var2 << 8 | (var3 = var0.get("z").asInt(0) - this.z & 0xF) << 4 | var1;
                if (this.blockEntities.put(var4, var0) != null) {
                    LOGGER.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.x, this.z, var1, var2, var3});
                }
            }));
            boolean var1 = var0.get("convertedFromAlphaFormat").asBoolean(false);
            var0.get("Sections").asStreamOpt().result().ifPresent(var02 -> var02.forEach(var0 -> {
                c var1 = new c((Dynamic<?>)var0);
                this.sides = var1.upgrade(this.sides);
                this.sections[var1.y] = var1;
            }));
            for (c var5 : this.sections) {
                if (var5 == null) continue;
                block14: for (Map.Entry var7 : var5.toFix.entrySet()) {
                    int var8 = var5.y << 12;
                    switch ((Integer)var7.getKey()) {
                        case 2: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!"minecraft:grass_block".equals(ChunkConverterPalette.getName(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.getName(this.getBlock(d.relative(var10, Direction.UP)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.setBlock(var10, SNOWY_GRASS);
                            }
                            continue block14;
                        }
                        case 3: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!"minecraft:podzol".equals(ChunkConverterPalette.getName(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.getName(this.getBlock(d.relative(var10, Direction.UP)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.setBlock(var10, SNOWY_PODZOL);
                            }
                            continue block14;
                        }
                        case 110: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!"minecraft:mycelium".equals(ChunkConverterPalette.getName(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.getName(this.getBlock(d.relative(var10, Direction.UP)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.setBlock(var10, SNOWY_MYCELIUM);
                            }
                            continue block14;
                        }
                        case 25: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.removeBlockEntity(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = Boolean.toString(var11.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(var11.get("note").asInt(0), 0), 24);
                                this.setBlock(var10, NOTE_BLOCK_MAP.getOrDefault(var12, NOTE_BLOCK_MAP.get("false0")));
                            }
                            continue block14;
                        }
                        case 26: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int var13;
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlockEntity(var10 |= var8);
                                var12 = this.getBlock(var10);
                                if (var11 == null || (var13 = var11.get("color").asInt(0)) == 14 || var13 < 0 || var13 >= 16 || !BED_BLOCK_MAP.containsKey(var14 = ChunkConverterPalette.getProperty(var12, "facing") + ChunkConverterPalette.getProperty(var12, "occupied") + ChunkConverterPalette.getProperty(var12, "part") + var13)) continue;
                                this.setBlock(var10, BED_BLOCK_MAP.get(var14));
                            }
                            continue block14;
                        }
                        case 176: 
                        case 177: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int var13;
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlockEntity(var10 |= var8);
                                var12 = this.getBlock(var10);
                                if (var11 == null || (var13 = var11.get("Base").asInt(0)) == 15 || var13 < 0 || var13 >= 16 || !BANNER_BLOCK_MAP.containsKey(var14 = ChunkConverterPalette.getProperty(var12, (Integer)var7.getKey() == 176 ? "rotation" : "facing") + "_" + var13)) continue;
                                this.setBlock(var10, BANNER_BLOCK_MAP.get(var14));
                            }
                            continue block14;
                        }
                        case 86: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!"minecraft:carved_pumpkin".equals(ChunkConverterPalette.getName(var11)) || !"minecraft:grass_block".equals(var12 = ChunkConverterPalette.getName(this.getBlock(d.relative(var10, Direction.DOWN)))) && !"minecraft:dirt".equals(var12)) continue;
                                this.setBlock(var10, PUMPKIN);
                            }
                            continue block14;
                        }
                        case 140: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.removeBlockEntity(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = var11.get("Item").asString("") + var11.get("Data").asInt(0);
                                this.setBlock(var10, FLOWER_POT_MAP.getOrDefault(var12, FLOWER_POT_MAP.get("minecraft:air0")));
                            }
                            continue block14;
                        }
                        case 144: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlockEntity(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = String.valueOf(var11.get("SkullType").asInt(0));
                                String var13 = ChunkConverterPalette.getProperty(this.getBlock(var10), "facing");
                                var14 = "up".equals(var13) || "down".equals(var13) ? var12 + String.valueOf(var11.get("Rot").asInt(0)) : var12 + var13;
                                var11.remove("SkullType");
                                var11.remove("facing");
                                var11.remove("Rot");
                                this.setBlock(var10, SKULL_MAP.getOrDefault(var14, SKULL_MAP.get("0north")));
                            }
                            continue block14;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!ChunkConverterPalette.getName(var11).endsWith("_door") || !"lower".equals(ChunkConverterPalette.getProperty(var12 = this.getBlock(var10), "half"))) continue;
                                int var13 = d.relative(var10, Direction.UP);
                                var14 = this.getBlock(var13);
                                String var15 = ChunkConverterPalette.getName(var12);
                                if (!var15.equals(ChunkConverterPalette.getName(var14))) continue;
                                String var16 = ChunkConverterPalette.getProperty(var12, "facing");
                                String var17 = ChunkConverterPalette.getProperty(var12, "open");
                                String var18 = var1 ? "left" : ChunkConverterPalette.getProperty(var14, "hinge");
                                String var19 = var1 ? "false" : ChunkConverterPalette.getProperty(var14, "powered");
                                this.setBlock(var10, DOOR_MAP.get(var15 + var16 + "lower" + var18 + var17 + var19));
                                this.setBlock(var13, DOOR_MAP.get(var15 + var16 + "upper" + var18 + var17 + var19));
                            }
                            continue block14;
                        }
                        case 175: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.getBlock(var10 |= var8);
                                if (!"upper".equals(ChunkConverterPalette.getProperty(var11, "half"))) continue;
                                var12 = this.getBlock(d.relative(var10, Direction.DOWN));
                                String var13 = ChunkConverterPalette.getName(var12);
                                if ("minecraft:sunflower".equals(var13)) {
                                    this.setBlock(var10, UPPER_SUNFLOWER);
                                    continue;
                                }
                                if ("minecraft:lilac".equals(var13)) {
                                    this.setBlock(var10, UPPER_LILAC);
                                    continue;
                                }
                                if ("minecraft:tall_grass".equals(var13)) {
                                    this.setBlock(var10, UPPER_TALL_GRASS);
                                    continue;
                                }
                                if ("minecraft:large_fern".equals(var13)) {
                                    this.setBlock(var10, UPPER_LARGE_FERN);
                                    continue;
                                }
                                if ("minecraft:rose_bush".equals(var13)) {
                                    this.setBlock(var10, UPPER_ROSE_BUSH);
                                    continue;
                                }
                                if (!"minecraft:peony".equals(var13)) continue;
                                this.setBlock(var10, UPPER_PEONY);
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> getBlockEntity(int var0) {
            return (Dynamic)this.blockEntities.get(var0);
        }

        @Nullable
        private Dynamic<?> removeBlockEntity(int var0) {
            return (Dynamic)this.blockEntities.remove(var0);
        }

        public static int relative(int var0, Direction var1) {
            switch (var1.getAxis()) {
                case X: {
                    int var2 = (var0 & 0xF) + var1.getAxisDirection().getStep();
                    return var2 < 0 || var2 > 15 ? -1 : var0 & 0xFFFFFFF0 | var2;
                }
                case Y: {
                    int var3 = (var0 >> 8) + var1.getAxisDirection().getStep();
                    return var3 < 0 || var3 > 255 ? -1 : var0 & 0xFF | var3 << 8;
                }
                case Z: {
                    int var4 = (var0 >> 4 & 0xF) + var1.getAxisDirection().getStep();
                    return var4 < 0 || var4 > 15 ? -1 : var0 & 0xFFFFFF0F | var4 << 4;
                }
            }
            return -1;
        }

        private void setBlock(int var0, Dynamic<?> var1) {
            if (var0 < 0 || var0 > 65535) {
                return;
            }
            c var2 = this.getSection(var0);
            if (var2 == null) {
                return;
            }
            var2.setBlock(var0 & 0xFFF, var1);
        }

        @Nullable
        private c getSection(int var0) {
            int var1 = var0 >> 12;
            return var1 < this.sections.length ? this.sections[var1] : null;
        }

        public Dynamic<?> getBlock(int var0) {
            if (var0 < 0 || var0 > 65535) {
                return AIR;
            }
            c var1 = this.getSection(var0);
            if (var1 == null) {
                return AIR;
            }
            return var1.getBlock(var0 & 0xFFF);
        }

        public Dynamic<?> write() {
            Dynamic var0 = this.level;
            var0 = this.blockEntities.isEmpty() ? var0.remove("TileEntities") : var0.set("TileEntities", var0.createList(this.blockEntities.values().stream()));
            Dynamic var1 = var0.emptyMap();
            ArrayList var2 = Lists.newArrayList();
            for (c var6 : this.sections) {
                if (var6 == null) continue;
                var2.add(var6.write());
                var1 = var1.set(String.valueOf(var6.y), var1.createIntList(Arrays.stream(var6.update.toIntArray())));
            }
            Dynamic var3 = var0.emptyMap();
            var3 = var3.set("Sides", var3.createByte((byte)this.sides));
            var3 = var3.set("Indices", var1);
            return var0.set("UpgradeData", var3).set("Sections", var3.createList(var2.stream()));
        }
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction DOWN = new Direction(AxisDirection.NEGATIVE, Axis.Y);
        public static final /* enum */ Direction UP = new Direction(AxisDirection.POSITIVE, Axis.Y);
        public static final /* enum */ Direction NORTH = new Direction(AxisDirection.NEGATIVE, Axis.Z);
        public static final /* enum */ Direction SOUTH = new Direction(AxisDirection.POSITIVE, Axis.Z);
        public static final /* enum */ Direction WEST = new Direction(AxisDirection.NEGATIVE, Axis.X);
        public static final /* enum */ Direction EAST = new Direction(AxisDirection.POSITIVE, Axis.X);
        private final Axis axis;
        private final AxisDirection axisDirection;
        private static final /* synthetic */ Direction[] i;

        public static Direction[] values() {
            return (Direction[])i.clone();
        }

        public static Direction valueOf(String var0) {
            return Enum.valueOf(Direction.class, var0);
        }

        private Direction(AxisDirection var2, Axis var3) {
            this.axis = var3;
            this.axisDirection = var2;
        }

        public AxisDirection getAxisDirection() {
            return this.axisDirection;
        }

        public Axis getAxis() {
            return this.axis;
        }

        private static /* synthetic */ Direction[] c() {
            return new Direction[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        }

        static {
            i = Direction.c();
        }

        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis X = new Axis();
            public static final /* enum */ Axis Y = new Axis();
            public static final /* enum */ Axis Z = new Axis();
            private static final /* synthetic */ Axis[] d;

            public static Axis[] values() {
                return (Axis[])d.clone();
            }

            public static Axis valueOf(String var0) {
                return Enum.valueOf(Axis.class, var0);
            }

            private static /* synthetic */ Axis[] a() {
                return new Axis[]{X, Y, Z};
            }

            static {
                d = Axis.a();
            }
        }

        public static final class AxisDirection
        extends Enum<AxisDirection> {
            public static final /* enum */ AxisDirection POSITIVE = new AxisDirection(1);
            public static final /* enum */ AxisDirection NEGATIVE = new AxisDirection(-1);
            private final int step;
            private static final /* synthetic */ AxisDirection[] d;

            public static AxisDirection[] values() {
                return (AxisDirection[])d.clone();
            }

            public static AxisDirection valueOf(String var0) {
                return Enum.valueOf(AxisDirection.class, var0);
            }

            private AxisDirection(int var2) {
                this.step = var2;
            }

            public int getStep() {
                return this.step;
            }

            private static /* synthetic */ AxisDirection[] b() {
                return new AxisDirection[]{POSITIVE, NEGATIVE};
            }

            static {
                d = AxisDirection.b();
            }
        }
    }

    static class a {
        private static final int SIZE = 2048;
        private static final int NIBBLE_SIZE = 4;
        private final byte[] data;

        public a() {
            this.data = new byte[2048];
        }

        public a(byte[] var0) {
            this.data = var0;
            if (var0.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + var0.length);
            }
        }

        public int get(int var0, int var1, int var2) {
            int var3 = this.getPosition(var1 << 8 | var2 << 4 | var0);
            if (this.isFirst(var1 << 8 | var2 << 4 | var0)) {
                return this.data[var3] & 0xF;
            }
            return this.data[var3] >> 4 & 0xF;
        }

        private boolean isFirst(int var0) {
            return (var0 & 1) == 0;
        }

        private int getPosition(int var0) {
            return var0 >> 1;
        }
    }

    static class c {
        private final RegistryID<Dynamic<?>> palette = RegistryID.create(32);
        private final List<Dynamic<?>> listTag;
        private final Dynamic<?> section;
        private final boolean hasData;
        final Int2ObjectMap<IntList> toFix = new Int2ObjectLinkedOpenHashMap();
        final IntList update = new IntArrayList();
        public final int y;
        private final Set<Dynamic<?>> seen = Sets.newIdentityHashSet();
        private final int[] buffer = new int[4096];

        public c(Dynamic<?> var0) {
            this.listTag = Lists.newArrayList();
            this.section = var0;
            this.y = var0.get("Y").asInt(0);
            this.hasData = var0.get("Blocks").result().isPresent();
        }

        public Dynamic<?> getBlock(int var0) {
            if (var0 < 0 || var0 > 4095) {
                return AIR;
            }
            Dynamic<?> var1 = this.palette.byId(this.buffer[var0]);
            return var1 == null ? AIR : var1;
        }

        public void setBlock(int var0, Dynamic<?> var1) {
            if (this.seen.add(var1)) {
                this.listTag.add("%%FILTER_ME%%".equals(ChunkConverterPalette.getName(var1)) ? AIR : var1);
            }
            this.buffer[var0] = ChunkConverterPalette.idFor(this.palette, var1);
        }

        public int upgrade(int var02) {
            if (!this.hasData) {
                return var02;
            }
            ByteBuffer var1 = (ByteBuffer)this.section.get("Blocks").asByteBufferOpt().result().get();
            a var2 = this.section.get("Data").asByteBufferOpt().map(var0 -> new a(DataFixUtils.toArray((ByteBuffer)var0))).result().orElseGet(a::new);
            a var3 = this.section.get("Add").asByteBufferOpt().map(var0 -> new a(DataFixUtils.toArray((ByteBuffer)var0))).result().orElseGet(a::new);
            this.seen.add(AIR);
            ChunkConverterPalette.idFor(this.palette, AIR);
            this.listTag.add(AIR);
            for (int var4 = 0; var4 < 4096; ++var4) {
                int var5 = var4 & 0xF;
                int var6 = var4 >> 8 & 0xF;
                int var7 = var4 >> 4 & 0xF;
                int var8 = var3.get(var5, var6, var7) << 12 | (var1.get(var4) & 0xFF) << 4 | var2.get(var5, var6, var7);
                if (FIX.get(var8 >> 4)) {
                    this.addFix(var8 >> 4, var4);
                }
                if (VIRTUAL.get(var8 >> 4)) {
                    int var9 = ChunkConverterPalette.getSideMask(var5 == 0, var5 == 15, var7 == 0, var7 == 15);
                    if (var9 == 0) {
                        this.update.add(var4);
                    } else {
                        var02 |= var9;
                    }
                }
                this.setBlock(var4, DataConverterFlattenData.getTag(var8));
            }
            return var02;
        }

        private void addFix(int var0, int var1) {
            IntList var2 = (IntList)this.toFix.get(var0);
            if (var2 == null) {
                var2 = new IntArrayList();
                this.toFix.put(var0, (Object)var2);
            }
            var2.add(var1);
        }

        public Dynamic<?> write() {
            Dynamic var0 = this.section;
            if (!this.hasData) {
                return var0;
            }
            var0 = var0.set("Palette", var0.createList(this.listTag.stream()));
            int var1 = Math.max(4, DataFixUtils.ceillog2((int)this.seen.size()));
            DataBitsPacked var2 = new DataBitsPacked(var1, 4096);
            for (int var3 = 0; var3 < this.buffer.length; ++var3) {
                var2.set(var3, this.buffer[var3]);
            }
            var0 = var0.set("BlockStates", var0.createLongList(Arrays.stream(var2.getRaw())));
            var0 = var0.remove("Blocks");
            var0 = var0.remove("Data");
            var0 = var0.remove("Add");
            return var0;
        }
    }
}

