/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.logging.LogUtils;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.minecraft.util.SignatureUpdater;
import org.slf4j.Logger;

public interface SignatureValidator {
    public static final SignatureValidator NO_VALIDATION = (var0, var1) -> true;
    public static final Logger LOGGER = LogUtils.getLogger();

    public boolean validate(SignatureUpdater var1, byte[] var2);

    default public boolean validate(byte[] var0, byte[] var12) {
        return this.validate(var1 -> var1.update(var0), var12);
    }

    private static boolean verifySignature(SignatureUpdater var0, byte[] var1, Signature var2) throws SignatureException {
        var0.update(var2::update);
        return var2.verify(var1);
    }

    public static SignatureValidator from(PublicKey var0, String var1) {
        return (var2, var3) -> {
            try {
                Signature var4 = Signature.getInstance(var1);
                var4.initVerify(var0);
                return SignatureValidator.verifySignature(var2, var3, var4);
            }
            catch (Exception var4) {
                LOGGER.error("Failed to verify signature", (Throwable)var4);
                return false;
            }
        };
    }

    public static SignatureValidator from(ServicesKeyInfo var0) {
        return (var1, var2) -> {
            Signature var3 = var0.signature();
            try {
                return SignatureValidator.verifySignature(var1, var2, var3);
            }
            catch (SignatureException var4) {
                LOGGER.error("Failed to verify Services signature", (Throwable)var4);
                return false;
            }
        };
    }
}

