/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutRecipes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();

    public int addRecipes(Collection<IRecipe<?>> var0, EntityPlayer var1) {
        ArrayList var2 = Lists.newArrayList();
        int var3 = 0;
        for (IRecipe<?> var5 : var0) {
            MinecraftKey var6 = var5.getId();
            if (this.known.contains(var6) || var5.isSpecial()) continue;
            this.add(var6);
            this.addHighlight(var6);
            var2.add(var6);
            CriterionTriggers.RECIPE_UNLOCKED.trigger(var1, var5);
            ++var3;
        }
        this.sendRecipes(PacketPlayOutRecipes.Action.ADD, var1, var2);
        return var3;
    }

    public int removeRecipes(Collection<IRecipe<?>> var0, EntityPlayer var1) {
        ArrayList var2 = Lists.newArrayList();
        int var3 = 0;
        for (IRecipe<?> var5 : var0) {
            MinecraftKey var6 = var5.getId();
            if (!this.known.contains(var6)) continue;
            this.remove(var6);
            var2.add(var6);
            ++var3;
        }
        this.sendRecipes(PacketPlayOutRecipes.Action.REMOVE, var1, var2);
        return var3;
    }

    private void sendRecipes(PacketPlayOutRecipes.Action var0, EntityPlayer var1, List<MinecraftKey> var2) {
        var1.connection.send(new PacketPlayOutRecipes(var0, var2, Collections.emptyList(), this.getBookSettings()));
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound var0 = new NBTTagCompound();
        this.getBookSettings().write(var0);
        NBTTagList var1 = new NBTTagList();
        for (MinecraftKey var3 : this.known) {
            var1.add(NBTTagString.valueOf(var3.toString()));
        }
        var0.put("recipes", var1);
        NBTTagList var2 = new NBTTagList();
        for (MinecraftKey var4 : this.highlight) {
            var2.add(NBTTagString.valueOf(var4.toString()));
        }
        var0.put("toBeDisplayed", var2);
        return var0;
    }

    public void fromNbt(NBTTagCompound var0, CraftingManager var1) {
        this.setBookSettings(RecipeBookSettings.read(var0));
        NBTTagList var2 = var0.getList("recipes", 8);
        this.loadRecipes(var2, this::add, var1);
        NBTTagList var3 = var0.getList("toBeDisplayed", 8);
        this.loadRecipes(var3, this::addHighlight, var1);
    }

    private void loadRecipes(NBTTagList var0, Consumer<IRecipe<?>> var1, CraftingManager var2) {
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            String var4 = var0.getString(var3);
            try {
                MinecraftKey var5 = new MinecraftKey(var4);
                Optional<IRecipe<?>> var6 = var2.byKey(var5);
                if (!var6.isPresent()) {
                    LOGGER.error("Tried to load unrecognized recipe: {} removed now.", (Object)var5);
                    continue;
                }
                var1.accept(var6.get());
                continue;
            }
            catch (ResourceKeyInvalidException var5) {
                LOGGER.error("Tried to load improperly formatted recipe: {} removed now.", (Object)var4);
            }
        }
    }

    public void sendInitialRecipeBook(EntityPlayer var0) {
        var0.connection.send(new PacketPlayOutRecipes(PacketPlayOutRecipes.Action.INIT, this.known, this.highlight, this.getBookSettings()));
    }
}

