/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;

public class ResourcePackSourceVanilla
extends BuiltInPackSource {
    private static final ResourcePackInfo VERSION_METADATA_SECTION = new ResourcePackInfo(IChatBaseComponent.translatable("dataPack.vanilla.description"), EnumResourcePackType.SERVER_DATA.getVersion(SharedConstants.getCurrentVersion()));
    private static final FeatureFlagsMetadataSection FEATURE_FLAGS_METADATA_SECTION = new FeatureFlagsMetadataSection(FeatureFlags.DEFAULT_FLAGS);
    private static final BuiltInMetadata BUILT_IN_METADATA = BuiltInMetadata.of(ResourcePackInfo.TYPE, VERSION_METADATA_SECTION, FeatureFlagsMetadataSection.TYPE, FEATURE_FLAGS_METADATA_SECTION);
    private static final IChatBaseComponent VANILLA_NAME = IChatBaseComponent.translatable("dataPack.vanilla.name");
    private static final MinecraftKey PACKS_DIR = new MinecraftKey("minecraft", "datapacks");

    public ResourcePackSourceVanilla() {
        super(EnumResourcePackType.SERVER_DATA, ResourcePackSourceVanilla.createVanillaPackSource(), PACKS_DIR);
    }

    private static ResourcePackVanilla createVanillaPackSource() {
        return new VanillaPackResourcesBuilder().setMetadata(BUILT_IN_METADATA).exposeNamespace("minecraft").applyDevelopmentConfig().pushJarResources().build();
    }

    @Override
    protected IChatBaseComponent getPackTitle(String var0) {
        return IChatBaseComponent.literal(var0);
    }

    @Override
    @Nullable
    protected ResourcePackLoader createVanillaPack(IResourcePack var0) {
        return ResourcePackLoader.readMetaAndCreate("vanilla", VANILLA_NAME, false, var1 -> var0, EnumResourcePackType.SERVER_DATA, ResourcePackLoader.Position.BOTTOM, PackSource.BUILT_IN);
    }

    @Override
    @Nullable
    protected ResourcePackLoader createBuiltinPack(String var0, ResourcePackLoader.c var1, IChatBaseComponent var2) {
        return ResourcePackLoader.readMetaAndCreate(var0, var2, false, var1, EnumResourcePackType.SERVER_DATA, ResourcePackLoader.Position.TOP, PackSource.FEATURE);
    }

    public static ResourcePackRepository createPackRepository(Path var0) {
        return new ResourcePackRepository(new ResourcePackSourceVanilla(), new ResourcePackSourceFolder(var0, EnumResourcePackType.SERVER_DATA, PackSource.WORLD));
    }

    public static ResourcePackRepository createPackRepository(Convertable.ConversionSession var0) {
        return ResourcePackSourceVanilla.createPackRepository(var0.getLevelPath(SavedFile.DATAPACK_DIR));
    }
}

