/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConnection;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int FAKE_PROTOCOL_VERSION = 127;
    private final ServerConnection serverConnectionListener;

    public LegacyPingHandler(ServerConnection var0) {
        this.serverConnectionListener = var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext var0, Object var1) {
        ByteBuf var2 = (ByteBuf)var1;
        var2.markReaderIndex();
        boolean var3 = true;
        try {
            if (var2.readUnsignedByte() != 254) {
                return;
            }
            InetSocketAddress var4 = (InetSocketAddress)var0.channel().remoteAddress();
            MinecraftServer var5 = this.serverConnectionListener.getServer();
            int var6 = var2.readableBytes();
            switch (var6) {
                case 0: {
                    LOGGER.debug("Ping: (<1.3.x) from {}:{}", (Object)var4.getAddress(), (Object)var4.getPort());
                    String var7 = String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", var5.getMotd(), var5.getPlayerCount(), var5.getMaxPlayers());
                    this.sendFlushAndClose(var0, this.createReply(var7));
                    break;
                }
                case 1: {
                    if (var2.readUnsignedByte() != 1) {
                        return;
                    }
                    LOGGER.debug("Ping: (1.4-1.5.x) from {}:{}", (Object)var4.getAddress(), (Object)var4.getPort());
                    String var7 = String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, var5.getServerVersion(), var5.getMotd(), var5.getPlayerCount(), var5.getMaxPlayers());
                    this.sendFlushAndClose(var0, this.createReply(var7));
                    break;
                }
                default: {
                    boolean var7 = var2.readUnsignedByte() == 1;
                    var7 &= var2.readUnsignedByte() == 250;
                    var7 &= "MC|PingHost".equals(new String(var2.readBytes(var2.readShort() * 2).array(), StandardCharsets.UTF_16BE));
                    int var8 = var2.readUnsignedShort();
                    var7 &= var2.readUnsignedByte() >= 73;
                    var7 &= 3 + var2.readBytes(var2.readShort() * 2).array().length + 4 == var8;
                    var7 &= var2.readInt() <= 65535;
                    if (!(var7 &= var2.readableBytes() == 0)) {
                        return;
                    }
                    LOGGER.debug("Ping: (1.6) from {}:{}", (Object)var4.getAddress(), (Object)var4.getPort());
                    String var9 = String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, var5.getServerVersion(), var5.getMotd(), var5.getPlayerCount(), var5.getMaxPlayers());
                    ByteBuf var10 = this.createReply(var9);
                    try {
                        this.sendFlushAndClose(var0, var10);
                        break;
                    }
                    finally {
                        var10.release();
                    }
                }
            }
            var2.release();
            var3 = false;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (var3) {
                var2.resetReaderIndex();
                var0.channel().pipeline().remove("legacy_query");
                var0.fireChannelRead(var1);
            }
        }
    }

    private void sendFlushAndClose(ChannelHandlerContext var0, ByteBuf var1) {
        var0.pipeline().firstContext().writeAndFlush((Object)var1).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private ByteBuf createReply(String var0) {
        ByteBuf var1 = Unpooled.buffer();
        var1.writeByte(255);
        char[] var2 = var0.toCharArray();
        var1.writeShort(var2.length);
        for (char var6 : var2) {
            var1.writeChar((int)var6);
        }
        return var1;
    }
}

