/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.commands.data.CommandDataAccessorEntity;
import net.minecraft.server.commands.data.CommandDataAccessorTile;
import net.minecraft.server.commands.data.CommandDataStorage;
import net.minecraft.util.MathHelper;

public class CommandData {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.data.get.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.data.get.unknown", var0));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.data.modify.expected_object", var0));
    public static final List<Function<String, c>> ALL_PROVIDERS = ImmutableList.of(CommandDataAccessorEntity.PROVIDER, CommandDataAccessorTile.PROVIDER, CommandDataStorage.PROVIDER);
    public static final List<c> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(var0 -> (c)var0.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<c> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(var0 -> (c)var0.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        LiteralArgumentBuilder var1 = (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("data").requires(var0 -> var0.hasPermission(2));
        for (c var3 : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var1.then(var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("merge"), var12 -> var12.then(net.minecraft.commands.CommandDispatcher.argument("nbt", ArgumentNBTTag.compoundTag()).executes(var1 -> CommandData.mergeData((CommandListenerWrapper)var1.getSource(), var3.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTTag.getCompoundTag(var1, "nbt"))))))).then(var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("get"), var12 -> var12.executes(var1 -> CommandData.getData((CommandListenerWrapper)var1.getSource(), var3.access((CommandContext<CommandListenerWrapper>)var1))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).executes(var1 -> CommandData.getData((CommandListenerWrapper)var1.getSource(), var3.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path")))).then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).executes(var1 -> CommandData.getNumeric((CommandListenerWrapper)var1.getSource(), var3.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path"), DoubleArgumentType.getDouble((CommandContext)var1, (String)"scale")))))))).then(var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("remove"), var12 -> var12.then(net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).executes(var1 -> CommandData.removeData((CommandListenerWrapper)var1.getSource(), var3.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path"))))))).then(CommandData.decorateModification((var02, var12) -> var02.then(net.minecraft.commands.CommandDispatcher.literal("insert").then(net.minecraft.commands.CommandDispatcher.argument("index", IntegerArgumentType.integer()).then(var12.create((var0, var1, var2, var3) -> var2.insert(IntegerArgumentType.getInteger((CommandContext)var0, (String)"index"), var1, var3))))).then(net.minecraft.commands.CommandDispatcher.literal("prepend").then(var12.create((var0, var1, var2, var3) -> var2.insert(0, var1, var3)))).then(net.minecraft.commands.CommandDispatcher.literal("append").then(var12.create((var0, var1, var2, var3) -> var2.insert(-1, var1, var3)))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(var12.create((var0, var1, var2, var3) -> var2.set(var1, (NBTBase)Iterables.getLast((Iterable)var3))))).then(net.minecraft.commands.CommandDispatcher.literal("merge").then(var12.create((var0, var1, var2, var3) -> {
                NBTTagCompound var4 = new NBTTagCompound();
                for (NBTBase var6 : var3) {
                    if (ArgumentNBTKey.g.isTooDeep(var6, 0)) {
                        throw ArgumentNBTKey.ERROR_DATA_TOO_DEEP.create();
                    }
                    if (var6 instanceof NBTTagCompound) {
                        NBTTagCompound var7 = (NBTTagCompound)var6;
                        var4.merge(var7);
                        continue;
                    }
                    throw ERROR_EXPECTED_OBJECT.create((Object)var6);
                }
                List<NBTBase> var5 = var2.getOrCreate(var1, NBTTagCompound::new);
                int var6 = 0;
                for (NBTBase var8 : var5) {
                    if (!(var8 instanceof NBTTagCompound)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)var8);
                    }
                    NBTTagCompound var9 = (NBTTagCompound)var8;
                    NBTTagCompound var10 = var9.copy();
                    var9.merge(var4);
                    var6 += var10.equals(var9) ? 0 : 1;
                }
                return var6;
            })))));
        }
        var03.register(var1);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandListenerWrapper, ?>, b> var0) {
        LiteralArgumentBuilder<CommandListenerWrapper> var1 = net.minecraft.commands.CommandDispatcher.literal("modify");
        for (c var3 : TARGET_PROVIDERS) {
            var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)var1, var22 -> {
                RequiredArgumentBuilder<CommandListenerWrapper, ArgumentNBTKey.g> var3 = net.minecraft.commands.CommandDispatcher.argument("targetPath", ArgumentNBTKey.nbtPath());
                for (c var5 : SOURCE_PROVIDERS) {
                    var0.accept((ArgumentBuilder<CommandListenerWrapper, ?>)var3, var2 -> var5.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("from"), var32 -> var32.executes(var3 -> {
                        List<NBTBase> var4 = Collections.singletonList(var5.access((CommandContext<CommandListenerWrapper>)var3).getData());
                        return CommandData.manipulateData((CommandContext<CommandListenerWrapper>)var3, var3, var2, var4);
                    }).then(net.minecraft.commands.CommandDispatcher.argument("sourcePath", ArgumentNBTKey.nbtPath()).executes(var3 -> {
                        CommandDataAccessor var4 = var5.access((CommandContext<CommandListenerWrapper>)var3);
                        ArgumentNBTKey.g var5 = ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var3, "sourcePath");
                        List<NBTBase> var6 = var5.get(var4.getData());
                        return CommandData.manipulateData((CommandContext<CommandListenerWrapper>)var3, var3, var2, var6);
                    }))));
                }
                var0.accept((ArgumentBuilder<CommandListenerWrapper, ?>)var3, var1 -> net.minecraft.commands.CommandDispatcher.literal("value").then(net.minecraft.commands.CommandDispatcher.argument("value", ArgumentNBTBase.nbtTag()).executes(var2 -> {
                    List<NBTBase> var3 = Collections.singletonList(ArgumentNBTBase.getNbtTag(var2, "value"));
                    return CommandData.manipulateData((CommandContext<CommandListenerWrapper>)var2, var3, var1, var3);
                })));
                return var22.then(var3);
            });
        }
        return var1;
    }

    private static int manipulateData(CommandContext<CommandListenerWrapper> var0, c var1, a var2, List<NBTBase> var3) throws CommandSyntaxException {
        CommandDataAccessor var4 = var1.access(var0);
        ArgumentNBTKey.g var5 = ArgumentNBTKey.getPath(var0, "targetPath");
        NBTTagCompound var6 = var4.getData();
        int var7 = var2.modify(var0, var6, var5, var3);
        if (var7 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var4.setData(var6);
        ((CommandListenerWrapper)var0.getSource()).sendSuccess(var4.getModifiedSuccess(), true);
        return var7;
    }

    private static int removeData(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2) throws CommandSyntaxException {
        NBTTagCompound var3 = var1.getData();
        int var4 = var2.remove(var3);
        if (var4 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var1.setData(var3);
        var0.sendSuccess(var1.getModifiedSuccess(), true);
        return var4;
    }

    private static NBTBase getSingleTag(ArgumentNBTKey.g var0, CommandDataAccessor var1) throws CommandSyntaxException {
        List<NBTBase> var2 = var0.get(var1.getData());
        Iterator var3 = var2.iterator();
        NBTBase var4 = (NBTBase)var3.next();
        if (var3.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return var4;
    }

    private static int getData(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2) throws CommandSyntaxException {
        int var4;
        NBTBase var3 = CommandData.getSingleTag(var2, var1);
        if (var3 instanceof NBTNumber) {
            var4 = MathHelper.floor(((NBTNumber)var3).getAsDouble());
        } else if (var3 instanceof NBTList) {
            var4 = ((NBTList)var3).size();
        } else if (var3 instanceof NBTTagCompound) {
            var4 = ((NBTTagCompound)var3).size();
        } else if (var3 instanceof NBTTagString) {
            var4 = var3.getAsString().length();
        } else {
            throw ERROR_GET_NON_EXISTENT.create((Object)var2.toString());
        }
        var0.sendSuccess(var1.getPrintSuccess(var3), false);
        return var4;
    }

    private static int getNumeric(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2, double var3) throws CommandSyntaxException {
        NBTBase var5 = CommandData.getSingleTag(var2, var1);
        if (!(var5 instanceof NBTNumber)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)var2.toString());
        }
        int var6 = MathHelper.floor(((NBTNumber)var5).getAsDouble() * var3);
        var0.sendSuccess(var1.getPrintSuccess(var2, var3, var6), false);
        return var6;
    }

    private static int getData(CommandListenerWrapper var0, CommandDataAccessor var1) throws CommandSyntaxException {
        var0.sendSuccess(var1.getPrintSuccess(var1.getData()), false);
        return 1;
    }

    private static int mergeData(CommandListenerWrapper var0, CommandDataAccessor var1, NBTTagCompound var2) throws CommandSyntaxException {
        NBTTagCompound var3 = var1.getData();
        if (ArgumentNBTKey.g.isTooDeep(var2, 0)) {
            throw ArgumentNBTKey.ERROR_DATA_TOO_DEEP.create();
        }
        NBTTagCompound var4 = var3.copy().merge(var2);
        if (var3.equals(var4)) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var1.setData(var4);
        var0.sendSuccess(var1.getModifiedSuccess(), true);
        return 1;
    }

    public static interface c {
        public CommandDataAccessor access(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandListenerWrapper, ?> wrap(ArgumentBuilder<CommandListenerWrapper, ?> var1, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2);
    }

    static interface a {
        public int modify(CommandContext<CommandListenerWrapper> var1, NBTTagCompound var2, ArgumentNBTKey.g var3, List<NBTBase> var4) throws CommandSyntaxException;
    }

    static interface b {
        public ArgumentBuilder<CommandListenerWrapper, ?> create(a var1);
    }
}

