/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;

public class CommandGive {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("give").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemStack.item(var1)).executes(var0 -> CommandGive.giveItem((CommandListenerWrapper)var0.getSource(), ArgumentItemStack.getItem(var0, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), 1))).then(net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)1)).executes(var0 -> CommandGive.giveItem((CommandListenerWrapper)var0.getSource(), ArgumentItemStack.getItem(var0, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count")))))));
    }

    private static int giveItem(CommandListenerWrapper var0, ArgumentPredicateItemStack var1, Collection<EntityPlayer> var2, int var3) throws CommandSyntaxException {
        int var4 = var1.getItem().getMaxStackSize();
        int var5 = var4 * 100;
        if (var3 > var5) {
            var0.sendFailure(IChatBaseComponent.translatable("commands.give.failed.toomanyitems", var5, var1.createItemStack(var3, false).getDisplayName()));
            return 0;
        }
        for (EntityPlayer var7 : var2) {
            int var8 = var3;
            while (var8 > 0) {
                EntityItem var12;
                int var9 = Math.min(var4, var8);
                var8 -= var9;
                ItemStack var10 = var1.createItemStack(var9, false);
                boolean var11 = var7.getInventory().add(var10);
                if (!var11 || !var10.isEmpty()) {
                    var12 = var7.drop(var10, false);
                    if (var12 == null) continue;
                    var12.setNoPickUpDelay();
                    var12.setOwner(var7.getUUID());
                    continue;
                }
                var10.setCount(1);
                var12 = var7.drop(var10, false);
                if (var12 != null) {
                    var12.makeFakeItem();
                }
                var7.level.playSound(null, var7.getX(), var7.getY(), var7.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((var7.getRandom().nextFloat() - var7.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                var7.containerMenu.broadcastChanges();
            }
        }
        if (var2.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.give.success.single", var3, var1.createItemStack(var3, false).getDisplayName(), var2.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.give.success.single", var3, var1.createItemStack(var3, false).getDisplayName(), var2.size()), true);
        }
        return var2.size();
    }
}

