/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final CommandBuildContext.a commandBuildContext;
    public CommandDispatcher commands;
    private final CraftingManager recipes = new CraftingManager();
    private final TagRegistry tagManager;
    private final LootPredicateManager predicateManager = new LootPredicateManager();
    private final LootTableRegistry lootTables = new LootTableRegistry(this.predicateManager);
    private final ItemModifierManager itemModifierManager = new ItemModifierManager(this.predicateManager, this.lootTables);
    private final AdvancementDataWorld advancements = new AdvancementDataWorld(this.predicateManager);
    private final CustomFunctionManager functionLibrary;

    public DataPackResources(IRegistryCustom.Dimension var0, FeatureFlagSet var1, CommandDispatcher.ServerType var2, int var3) {
        this.tagManager = new TagRegistry(var0);
        this.commandBuildContext = CommandBuildContext.configurable(var0, var1);
        this.commands = new CommandDispatcher(var2, this.commandBuildContext);
        this.commandBuildContext.missingTagAccessPolicy(CommandBuildContext.b.CREATE_NEW);
        this.functionLibrary = new CustomFunctionManager(var3, this.commands.getDispatcher());
    }

    public CustomFunctionManager getFunctionLibrary() {
        return this.functionLibrary;
    }

    public LootPredicateManager getPredicateManager() {
        return this.predicateManager;
    }

    public LootTableRegistry getLootTables() {
        return this.lootTables;
    }

    public ItemModifierManager getItemModifierManager() {
        return this.itemModifierManager;
    }

    public CraftingManager getRecipeManager() {
        return this.recipes;
    }

    public CommandDispatcher getCommands() {
        return this.commands;
    }

    public AdvancementDataWorld getAdvancements() {
        return this.advancements;
    }

    public List<IReloadListener> listeners() {
        return List.of(this.tagManager, this.predicateManager, this.recipes, this.lootTables, this.itemModifierManager, this.functionLibrary, this.advancements);
    }

    public static CompletableFuture<DataPackResources> loadResources(IResourceManager var0, IRegistryCustom.Dimension var12, FeatureFlagSet var22, CommandDispatcher.ServerType var3, int var4, Executor var5, Executor var6) {
        DataPackResources var7 = new DataPackResources(var12, var22, var3, var4);
        return ((CompletableFuture)Reloadable.create(var0, var7.listeners(), var5, var6, DATA_RELOAD_INITIAL_TASK, LOGGER.isDebugEnabled()).done().whenComplete((var1, var2) -> var0.commandBuildContext.missingTagAccessPolicy(CommandBuildContext.b.FAIL))).thenApply(var1 -> var7);
    }

    public void updateRegistryTags(IRegistryCustom var0) {
        this.tagManager.getResult().forEach(var1 -> DataPackResources.updateRegistryTags(var0, var1));
        Blocks.rebuildCache();
    }

    private static <T> void updateRegistryTags(IRegistryCustom var02, TagRegistry.a<T> var12) {
        ResourceKey var2 = var12.key();
        Map var3 = var12.tags().entrySet().stream().collect(Collectors.toUnmodifiableMap(var1 -> TagKey.create(var2, (MinecraftKey)var1.getKey()), var0 -> List.copyOf((Collection)var0.getValue())));
        var02.registryOrThrow(var2).bindTags(var3);
    }
}

