/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    private final b lookupProvider;

    private static b memoizeLookup(final b var0) {
        return new b(){
            private final Map<ResourceKey<? extends IRegistry<?>>, Optional<? extends a<?>>> lookups = new HashMap();

            @Override
            public <T> Optional<a<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var02) {
                return this.lookups.computeIfAbsent(var02, var0::lookup);
            }
        };
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, final HolderLookup.b var1) {
        return RegistryOps.create(var0, RegistryOps.memoizeLookup(new b(){

            public <E> Optional<a<E>> lookup(ResourceKey<? extends IRegistry<? extends E>> var02) {
                return var1.lookup(var02).map(var0 -> new a(var0, var0, var0.registryLifecycle()));
            }
        }));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, b var1) {
        return new RegistryOps<T>(var0, var1);
    }

    private RegistryOps(DynamicOps<T> var0, b var1) {
        super(var0);
        this.lookupProvider = var1;
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(a::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(a::getter);
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends IRegistry<? extends E>> var02) {
        return ExtraCodecs.retrieveContext(var1 -> {
            if (var1 instanceof RegistryOps) {
                RegistryOps var2 = (RegistryOps)var1;
                return var2.lookupProvider.lookup(var02).map(var0 -> DataResult.success(var0.getter(), (Lifecycle)var0.elementsLifecycle())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + var02)));
            }
            return DataResult.error((String)"Not a registry ops");
        }).forGetter(var0 -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.c<E>> retrieveElement(ResourceKey<E> var02) {
        ResourceKey var1 = ResourceKey.createRegistryKey(var02.registry());
        return ExtraCodecs.retrieveContext(var2 -> {
            if (var2 instanceof RegistryOps) {
                RegistryOps var3 = (RegistryOps)var2;
                return var3.lookupProvider.lookup(var1).flatMap(var1 -> var1.getter().get(var02)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Can't find value: " + var02)));
            }
            return DataResult.error((String)"Not a registry ops");
        }).forGetter(var0 -> null);
    }

    public static interface b {
        public <T> Optional<a<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var1);
    }

    public record a<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
    }
}

