/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.util.RegistryID;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class DataWatcherRegistry {
    private static final RegistryID<DataWatcherSerializer<?>> SERIALIZERS = RegistryID.create(16);
    public static final DataWatcherSerializer<Byte> BYTE = DataWatcherSerializer.simple((var0, var1) -> var0.writeByte(var1.byteValue()), PacketDataSerializer::readByte);
    public static final DataWatcherSerializer<Integer> INT = DataWatcherSerializer.simple(PacketDataSerializer::writeVarInt, PacketDataSerializer::readVarInt);
    public static final DataWatcherSerializer<Long> LONG = DataWatcherSerializer.simple(PacketDataSerializer::writeVarLong, PacketDataSerializer::readVarLong);
    public static final DataWatcherSerializer<Float> FLOAT = DataWatcherSerializer.simple(PacketDataSerializer::writeFloat, PacketDataSerializer::readFloat);
    public static final DataWatcherSerializer<String> STRING = DataWatcherSerializer.simple(PacketDataSerializer::writeUtf, PacketDataSerializer::readUtf);
    public static final DataWatcherSerializer<IChatBaseComponent> COMPONENT = DataWatcherSerializer.simple(PacketDataSerializer::writeComponent, PacketDataSerializer::readComponent);
    public static final DataWatcherSerializer<Optional<IChatBaseComponent>> OPTIONAL_COMPONENT = DataWatcherSerializer.optional(PacketDataSerializer::writeComponent, PacketDataSerializer::readComponent);
    public static final DataWatcherSerializer<ItemStack> ITEM_STACK = new DataWatcherSerializer<ItemStack>(){

        @Override
        public void write(PacketDataSerializer var0, ItemStack var1) {
            var0.writeItem(var1);
        }

        @Override
        public ItemStack read(PacketDataSerializer var0) {
            return var0.readItem();
        }

        @Override
        public ItemStack copy(ItemStack var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Optional<IBlockData>> BLOCK_STATE = new DataWatcherSerializer.a<Optional<IBlockData>>(){

        @Override
        public void write(PacketDataSerializer var0, Optional<IBlockData> var1) {
            if (var1.isPresent()) {
                var0.writeVarInt(Block.getId(var1.get()));
            } else {
                var0.writeVarInt(0);
            }
        }

        @Override
        public Optional<IBlockData> read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            if (var1 == 0) {
                return Optional.empty();
            }
            return Optional.of(Block.stateById(var1));
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Boolean> BOOLEAN = DataWatcherSerializer.simple(PacketDataSerializer::writeBoolean, PacketDataSerializer::readBoolean);
    public static final DataWatcherSerializer<ParticleParam> PARTICLE = new DataWatcherSerializer.a<ParticleParam>(){

        @Override
        public void write(PacketDataSerializer var0, ParticleParam var1) {
            var0.writeId(BuiltInRegistries.PARTICLE_TYPE, var1.getType());
            var1.writeToNetwork(var0);
        }

        @Override
        public ParticleParam read(PacketDataSerializer var0) {
            return this.readParticle(var0, var0.readById(BuiltInRegistries.PARTICLE_TYPE));
        }

        private <T extends ParticleParam> T readParticle(PacketDataSerializer var0, Particle<T> var1) {
            return var1.getDeserializer().fromNetwork(var1, var0);
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Vector3f> ROTATIONS = new DataWatcherSerializer.a<Vector3f>(){

        @Override
        public void write(PacketDataSerializer var0, Vector3f var1) {
            var0.writeFloat(var1.getX());
            var0.writeFloat(var1.getY());
            var0.writeFloat(var1.getZ());
        }

        @Override
        public Vector3f read(PacketDataSerializer var0) {
            return new Vector3f(var0.readFloat(), var0.readFloat(), var0.readFloat());
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<BlockPosition> BLOCK_POS = DataWatcherSerializer.simple(PacketDataSerializer::writeBlockPos, PacketDataSerializer::readBlockPos);
    public static final DataWatcherSerializer<Optional<BlockPosition>> OPTIONAL_BLOCK_POS = DataWatcherSerializer.optional(PacketDataSerializer::writeBlockPos, PacketDataSerializer::readBlockPos);
    public static final DataWatcherSerializer<EnumDirection> DIRECTION = DataWatcherSerializer.simpleEnum(EnumDirection.class);
    public static final DataWatcherSerializer<Optional<UUID>> OPTIONAL_UUID = DataWatcherSerializer.optional(PacketDataSerializer::writeUUID, PacketDataSerializer::readUUID);
    public static final DataWatcherSerializer<Optional<GlobalPos>> OPTIONAL_GLOBAL_POS = DataWatcherSerializer.optional(PacketDataSerializer::writeGlobalPos, PacketDataSerializer::readGlobalPos);
    public static final DataWatcherSerializer<NBTTagCompound> COMPOUND_TAG = new DataWatcherSerializer<NBTTagCompound>(){

        @Override
        public void write(PacketDataSerializer var0, NBTTagCompound var1) {
            var0.writeNbt(var1);
        }

        @Override
        public NBTTagCompound read(PacketDataSerializer var0) {
            return var0.readNbt();
        }

        @Override
        public NBTTagCompound copy(NBTTagCompound var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<VillagerData> VILLAGER_DATA = new DataWatcherSerializer.a<VillagerData>(){

        @Override
        public void write(PacketDataSerializer var0, VillagerData var1) {
            var0.writeId(BuiltInRegistries.VILLAGER_TYPE, var1.getType());
            var0.writeId(BuiltInRegistries.VILLAGER_PROFESSION, var1.getProfession());
            var0.writeVarInt(var1.getLevel());
        }

        @Override
        public VillagerData read(PacketDataSerializer var0) {
            return new VillagerData(var0.readById(BuiltInRegistries.VILLAGER_TYPE), var0.readById(BuiltInRegistries.VILLAGER_PROFESSION), var0.readVarInt());
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<OptionalInt> OPTIONAL_UNSIGNED_INT = new DataWatcherSerializer.a<OptionalInt>(){

        @Override
        public void write(PacketDataSerializer var0, OptionalInt var1) {
            var0.writeVarInt(var1.orElse(-1) + 1);
        }

        @Override
        public OptionalInt read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            return var1 == 0 ? OptionalInt.empty() : OptionalInt.of(var1 - 1);
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<EntityPose> POSE = DataWatcherSerializer.simpleEnum(EntityPose.class);
    public static final DataWatcherSerializer<CatVariant> CAT_VARIANT = DataWatcherSerializer.simpleId(BuiltInRegistries.CAT_VARIANT);
    public static final DataWatcherSerializer<FrogVariant> FROG_VARIANT = DataWatcherSerializer.simpleId(BuiltInRegistries.FROG_VARIANT);
    public static final DataWatcherSerializer<Holder<PaintingVariant>> PAINTING_VARIANT = DataWatcherSerializer.simpleId(BuiltInRegistries.PAINTING_VARIANT.asHolderIdMap());

    public static void registerSerializer(DataWatcherSerializer<?> var0) {
        SERIALIZERS.add(var0);
    }

    @Nullable
    public static DataWatcherSerializer<?> getSerializer(int var0) {
        return SERIALIZERS.byId(var0);
    }

    public static int getSerializedId(DataWatcherSerializer<?> var0) {
        return SERIALIZERS.getId(var0);
    }

    private DataWatcherRegistry() {
    }

    static {
        DataWatcherRegistry.registerSerializer(BYTE);
        DataWatcherRegistry.registerSerializer(INT);
        DataWatcherRegistry.registerSerializer(LONG);
        DataWatcherRegistry.registerSerializer(FLOAT);
        DataWatcherRegistry.registerSerializer(STRING);
        DataWatcherRegistry.registerSerializer(COMPONENT);
        DataWatcherRegistry.registerSerializer(OPTIONAL_COMPONENT);
        DataWatcherRegistry.registerSerializer(ITEM_STACK);
        DataWatcherRegistry.registerSerializer(BOOLEAN);
        DataWatcherRegistry.registerSerializer(ROTATIONS);
        DataWatcherRegistry.registerSerializer(BLOCK_POS);
        DataWatcherRegistry.registerSerializer(OPTIONAL_BLOCK_POS);
        DataWatcherRegistry.registerSerializer(DIRECTION);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UUID);
        DataWatcherRegistry.registerSerializer(BLOCK_STATE);
        DataWatcherRegistry.registerSerializer(COMPOUND_TAG);
        DataWatcherRegistry.registerSerializer(PARTICLE);
        DataWatcherRegistry.registerSerializer(VILLAGER_DATA);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UNSIGNED_INT);
        DataWatcherRegistry.registerSerializer(POSE);
        DataWatcherRegistry.registerSerializer(CAT_VARIANT);
        DataWatcherRegistry.registerSerializer(FROG_VARIANT);
        DataWatcherRegistry.registerSerializer(OPTIONAL_GLOBAL_POS);
        DataWatcherRegistry.registerSerializer(PAINTING_VARIANT);
    }
}

