/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> ENTITY_ID_POOL = new Object2IntOpenHashMap();
    private static final int MAX_ID_VALUE = 254;
    private final Entity entity;
    private final Int2ObjectMap<Item<?>> itemsById = new Int2ObjectOpenHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isDirty;

    public DataWatcher(Entity var0) {
        this.entity = var0;
    }

    public static <T> DataWatcherObject<T> defineId(Class<? extends Entity> var0, DataWatcherSerializer<T> var1) {
        int var2;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> var22 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!var22.equals(var0)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{var0, var22, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException var22) {
                // empty catch block
            }
        }
        if (ENTITY_ID_POOL.containsKey(var0)) {
            var2 = ENTITY_ID_POOL.getInt(var0) + 1;
        } else {
            int var3 = 0;
            Class<? extends Entity> var4 = var0;
            while (var4 != Entity.class) {
                if (!ENTITY_ID_POOL.containsKey(var4 = var4.getSuperclass())) continue;
                var3 = ENTITY_ID_POOL.getInt(var4) + 1;
                break;
            }
            var2 = var3;
        }
        if (var2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is 254)");
        }
        ENTITY_ID_POOL.put(var0, var2);
        return var1.createAccessor(var2);
    }

    public <T> void define(DataWatcherObject<T> var0, T var1) {
        int var2 = var0.getId();
        if (var2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + var2 + "! (Max is 254)");
        }
        if (this.itemsById.containsKey(var2)) {
            throw new IllegalArgumentException("Duplicate id value for " + var2 + "!");
        }
        if (DataWatcherRegistry.getSerializedId(var0.getSerializer()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + var0.getSerializer() + " for " + var2 + "!");
        }
        this.createDataItem(var0, var1);
    }

    private <T> void createDataItem(DataWatcherObject<T> var0, T var1) {
        Item<T> var2 = new Item<T>(var0, var1);
        this.lock.writeLock().lock();
        this.itemsById.put(var0.getId(), var2);
        this.lock.writeLock().unlock();
    }

    private <T> Item<T> getItem(DataWatcherObject<T> var0) {
        Item var1;
        this.lock.readLock().lock();
        try {
            var1 = (Item)this.itemsById.get(var0.getId());
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Getting synched entity data");
            CrashReportSystemDetails var4 = var3.addCategory("Synched entity data");
            var4.setDetail("Data ID", var0);
            throw new ReportedException(var3);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return var1;
    }

    public <T> T get(DataWatcherObject<T> var0) {
        return this.getItem(var0).getValue();
    }

    public <T> void set(DataWatcherObject<T> var0, T var1) {
        Item<T> var2 = this.getItem(var0);
        if (ObjectUtils.notEqual(var1, var2.getValue())) {
            var2.setValue(var1);
            this.entity.onSyncedDataUpdated(var0);
            var2.setDirty(true);
            this.isDirty = true;
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public List<b<?>> packDirty() {
        ArrayList var0 = null;
        if (this.isDirty) {
            this.lock.readLock().lock();
            for (Item var2 : this.itemsById.values()) {
                if (!var2.isDirty()) continue;
                var2.setDirty(false);
                if (var0 == null) {
                    var0 = new ArrayList();
                }
                var0.add(var2.value());
            }
            this.lock.readLock().unlock();
        }
        this.isDirty = false;
        return var0;
    }

    @Nullable
    public List<b<?>> getNonDefaultValues() {
        ArrayList var0 = null;
        this.lock.readLock().lock();
        for (Item var2 : this.itemsById.values()) {
            if (var2.isSetToDefault()) continue;
            if (var0 == null) {
                var0 = new ArrayList();
            }
            var0.add(var2.value());
        }
        this.lock.readLock().unlock();
        return var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignValues(List<b<?>> var0) {
        this.lock.writeLock().lock();
        try {
            for (b<?> var2 : var0) {
                Item var3 = (Item)this.itemsById.get(var2.id);
                if (var3 == null) continue;
                this.assignValue(var3, var2);
                this.entity.onSyncedDataUpdated(var3.getAccessor());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private <T> void assignValue(Item<T> var0, b<?> var1) {
        if (!Objects.equals(var1.serializer(), var0.accessor.getSerializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", var0.accessor.getId(), this.entity, var0.value, var0.value.getClass(), var1.value, var1.value.getClass()));
        }
        var0.setValue(var1.value);
    }

    public boolean isEmpty() {
        return this.itemsById.isEmpty();
    }

    public static class Item<T> {
        final DataWatcherObject<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public Item(DataWatcherObject<T> var0, T var1) {
            this.accessor = var0;
            this.initialValue = var1;
            this.value = var1;
        }

        public DataWatcherObject<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T var0) {
            this.value = var0;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean var0) {
            this.dirty = var0;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public b<T> value() {
            return b.create(this.accessor, this.value);
        }
    }

    public static final class b<T>
    extends Record {
        final int id;
        private final DataWatcherSerializer<T> serializer;
        final T value;

        public b(int var0, DataWatcherSerializer<T> var1, T var2) {
            this.id = var0;
            this.serializer = var1;
            this.value = var2;
        }

        public static <T> b<T> create(DataWatcherObject<T> var0, T var1) {
            DataWatcherSerializer<T> var2 = var0.getSerializer();
            return new b<T>(var0.getId(), var2, var2.copy(var1));
        }

        public void write(PacketDataSerializer var0) {
            int var1 = DataWatcherRegistry.getSerializedId(this.serializer);
            if (var1 < 0) {
                throw new EncoderException("Unknown serializer type " + this.serializer);
            }
            var0.writeByte(this.id);
            var0.writeVarInt(var1);
            this.serializer.write(var0, this.value);
        }

        public static b<?> read(PacketDataSerializer var0, int var1) {
            int var2 = var0.readVarInt();
            DataWatcherSerializer<?> var3 = DataWatcherRegistry.getSerializer(var2);
            if (var3 == null) {
                throw new DecoderException("Unknown serializer type " + var2);
            }
            return b.read(var0, var1, var3);
        }

        private static <T> b<T> read(PacketDataSerializer var0, int var1, DataWatcherSerializer<T> var2) {
            return new b<T>(var1, var2, var2.read(var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;serializer;value", "id", "serializer", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;serializer;value", "id", "serializer", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;serializer;value", "id", "serializer", "value"}, this, var0);
        }

        public int id() {
            return this.id;
        }

        public DataWatcherSerializer<T> serializer() {
            return this.serializer;
        }

        public T value() {
            return this.value;
        }
    }
}

