/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutWorldParticles
implements Packet<PacketListenerPlayOut> {
    private final double x;
    private final double y;
    private final double z;
    private final float xDist;
    private final float yDist;
    private final float zDist;
    private final float maxSpeed;
    private final int count;
    private final boolean overrideLimiter;
    private final ParticleParam particle;

    public <T extends ParticleParam> PacketPlayOutWorldParticles(T var0, boolean var1, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12) {
        this.particle = var0;
        this.overrideLimiter = var1;
        this.x = var2;
        this.y = var4;
        this.z = var6;
        this.xDist = var8;
        this.yDist = var9;
        this.zDist = var10;
        this.maxSpeed = var11;
        this.count = var12;
    }

    public PacketPlayOutWorldParticles(PacketDataSerializer var0) {
        Particle<?> var1 = var0.readById(BuiltInRegistries.PARTICLE_TYPE);
        this.overrideLimiter = var0.readBoolean();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.xDist = var0.readFloat();
        this.yDist = var0.readFloat();
        this.zDist = var0.readFloat();
        this.maxSpeed = var0.readFloat();
        this.count = var0.readInt();
        this.particle = this.readParticle(var0, var1);
    }

    private <T extends ParticleParam> T readParticle(PacketDataSerializer var0, Particle<T> var1) {
        return var1.getDeserializer().fromNetwork(var1, var0);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeId(BuiltInRegistries.PARTICLE_TYPE, this.particle.getType());
        var0.writeBoolean(this.overrideLimiter);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.xDist);
        var0.writeFloat(this.yDist);
        var0.writeFloat(this.zDist);
        var0.writeFloat(this.maxSpeed);
        var0.writeInt(this.count);
        this.particle.writeToNetwork(var0);
    }

    public boolean isOverrideLimiter() {
        return this.overrideLimiter;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXDist() {
        return this.xDist;
    }

    public float getYDist() {
        return this.yDist;
    }

    public float getZDist() {
        return this.zDist;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getCount() {
        return this.count;
    }

    public ParticleParam getParticle() {
        return this.particle;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleParticleEvent(this);
    }
}

