/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;

public record PacketPlayOutLogin(int playerId, boolean hardcore, EnumGamemode gameType, @Nullable EnumGamemode previousGameType, Set<ResourceKey<World>> levels, IRegistryCustom.Dimension registryHolder, ResourceKey<DimensionManager> dimensionType, ResourceKey<World> dimension, long seed, int maxPlayers, int chunkRadius, int simulationDistance, boolean reducedDebugInfo, boolean showDeathScreen, boolean isDebug, boolean isFlat, Optional<GlobalPos> lastDeathLocation) implements Packet<PacketListenerPlayOut>
{
    public PacketPlayOutLogin(PacketDataSerializer var02) {
        this(var02.readInt(), var02.readBoolean(), EnumGamemode.byId(var02.readByte()), EnumGamemode.byNullableId(var02.readByte()), var02.readCollection(Sets::newHashSetWithExpectedSize, var0 -> var0.readResourceKey(Registries.DIMENSION)), var02.readWithCodec(RegistrySynchronization.NETWORK_CODEC).freeze(), var02.readResourceKey(Registries.DIMENSION_TYPE), var02.readResourceKey(Registries.DIMENSION), var02.readLong(), var02.readVarInt(), var02.readVarInt(), var02.readVarInt(), var02.readBoolean(), var02.readBoolean(), var02.readBoolean(), var02.readBoolean(), var02.readOptional(PacketDataSerializer::readGlobalPos));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeInt(this.playerId);
        var0.writeBoolean(this.hardcore);
        var0.writeByte(this.gameType.getId());
        var0.writeByte(EnumGamemode.getNullableId(this.previousGameType));
        var0.writeCollection(this.levels, PacketDataSerializer::writeResourceKey);
        var0.writeWithCodec(RegistrySynchronization.NETWORK_CODEC, this.registryHolder);
        var0.writeResourceKey(this.dimensionType);
        var0.writeResourceKey(this.dimension);
        var0.writeLong(this.seed);
        var0.writeVarInt(this.maxPlayers);
        var0.writeVarInt(this.chunkRadius);
        var0.writeVarInt(this.simulationDistance);
        var0.writeBoolean(this.reducedDebugInfo);
        var0.writeBoolean(this.showDeathScreen);
        var0.writeBoolean(this.isDebug);
        var0.writeBoolean(this.isFlat);
        var0.writeOptional(this.lastDeathLocation, PacketDataSerializer::writeGlobalPos);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLogin(this);
    }
}

