/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;

public class PacketPlayOutEntityEffect
implements Packet<PacketListenerPlayOut> {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private final int entityId;
    private final MobEffectList effect;
    private final byte effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;
    @Nullable
    private final MobEffect.a factorData;

    public PacketPlayOutEntityEffect(int var0, MobEffect var1) {
        this.entityId = var0;
        this.effect = var1.getEffect();
        this.effectAmplifier = (byte)(var1.getAmplifier() & 0xFF);
        this.effectDurationTicks = var1.getDuration();
        byte var2 = 0;
        if (var1.isAmbient()) {
            var2 = (byte)(var2 | 1);
        }
        if (var1.isVisible()) {
            var2 = (byte)(var2 | 2);
        }
        if (var1.showIcon()) {
            var2 = (byte)(var2 | 4);
        }
        this.flags = var2;
        this.factorData = var1.getFactorData().orElse(null);
    }

    public PacketPlayOutEntityEffect(PacketDataSerializer var02) {
        this.entityId = var02.readVarInt();
        this.effect = var02.readById(BuiltInRegistries.MOB_EFFECT);
        this.effectAmplifier = var02.readByte();
        this.effectDurationTicks = var02.readVarInt();
        this.flags = var02.readByte();
        this.factorData = (MobEffect.a)var02.readNullable(var0 -> var0.readWithCodec(MobEffect.a.CODEC));
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.entityId);
        var02.writeId(BuiltInRegistries.MOB_EFFECT, this.effect);
        var02.writeByte(this.effectAmplifier);
        var02.writeVarInt(this.effectDurationTicks);
        var02.writeByte(this.flags);
        var02.writeNullable(this.factorData, (var0, var1) -> var0.writeWithCodec(MobEffect.a.CODEC, var1));
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateMobEffect(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public MobEffectList getEffect() {
        return this.effect;
    }

    public byte getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }

    @Nullable
    public MobEffect.a getFactorData() {
        return this.factorData;
    }
}

