/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<b> entries;

    public PacketPlayOutCommands(RootCommandNode<ICompletionProvider> var0) {
        Object2IntMap<CommandNode<ICompletionProvider>> var1 = PacketPlayOutCommands.enumerateNodes(var0);
        this.entries = PacketPlayOutCommands.createEntries(var1);
        this.rootIndex = var1.getInt(var0);
    }

    public PacketPlayOutCommands(PacketDataSerializer var0) {
        this.entries = var0.readList(PacketPlayOutCommands::readNode);
        this.rootIndex = var0.readVarInt();
        PacketPlayOutCommands.validateEntries(this.entries);
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
        var02.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<b> var0, BiPredicate<b, IntSet> var1) {
        IntOpenHashSet var2 = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)var0.size()));
        while (!var2.isEmpty()) {
            boolean var3 = var2.removeIf(arg_0 -> PacketPlayOutCommands.a(var1, var0, (IntSet)var2, arg_0));
            if (var3) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<b> var0) {
        PacketPlayOutCommands.validateEntries(var0, b::canBuild);
        PacketPlayOutCommands.validateEntries(var0, b::canResolve);
    }

    private static Object2IntMap<CommandNode<ICompletionProvider>> enumerateNodes(RootCommandNode<ICompletionProvider> var0) {
        CommandNode var3;
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        ArrayDeque var2 = Queues.newArrayDeque();
        var2.add(var0);
        while ((var3 = (CommandNode)var2.poll()) != null) {
            if (var1.containsKey((Object)var3)) continue;
            int var4 = var1.size();
            var1.put((Object)var3, var4);
            var2.addAll(var3.getChildren());
            if (var3.getRedirect() == null) continue;
            var2.add(var3.getRedirect());
        }
        return var1;
    }

    private static List<b> createEntries(Object2IntMap<CommandNode<ICompletionProvider>> var0) {
        ObjectArrayList var1 = new ObjectArrayList(var0.size());
        var1.size(var0.size());
        for (Object2IntMap.Entry var3 : Object2IntMaps.fastIterable(var0)) {
            var1.set(var3.getIntValue(), (Object)PacketPlayOutCommands.createEntry((CommandNode<ICompletionProvider>)((CommandNode)var3.getKey()), var0));
        }
        return var1;
    }

    private static b readNode(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        int[] var2 = var0.readVarIntArray();
        int var3 = (var1 & 8) != 0 ? var0.readVarInt() : 0;
        e var4 = PacketPlayOutCommands.read(var0, var1);
        return new b(var4, var1, var3, var2);
    }

    @Nullable
    private static e read(PacketDataSerializer var0, byte var1) {
        int var2 = var1 & 3;
        if (var2 == 2) {
            String var3 = var0.readUtf();
            int var4 = var0.readVarInt();
            ArgumentTypeInfo var5 = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(var4);
            if (var5 == null) {
                return null;
            }
            Object var6 = var5.deserializeFromNetwork(var0);
            MinecraftKey var7 = (var1 & 0x10) != 0 ? var0.readResourceLocation() : null;
            return new a(var3, (ArgumentTypeInfo.a<?>)var6, var7);
        }
        if (var2 == 1) {
            String var3 = var0.readUtf();
            return new c(var3);
        }
        return null;
    }

    private static b createEntry(CommandNode<ICompletionProvider> var0, Object2IntMap<CommandNode<ICompletionProvider>> var1) {
        Object var6;
        e var4;
        int var3;
        int var2 = 0;
        if (var0.getRedirect() != null) {
            var2 |= 8;
            var3 = var1.getInt((Object)var0.getRedirect());
        } else {
            var3 = 0;
        }
        if (var0.getCommand() != null) {
            var2 |= 4;
        }
        if (var0 instanceof RootCommandNode) {
            var2 |= 0;
            var4 = null;
        } else if (var0 instanceof ArgumentCommandNode) {
            var6 = (ArgumentCommandNode)var0;
            var4 = new a((ArgumentCommandNode<ICompletionProvider, ?>)var6);
            var2 |= 2;
            if (var6.getCustomSuggestions() != null) {
                var2 |= 0x10;
            }
        } else if (var0 instanceof LiteralCommandNode) {
            LiteralCommandNode var5 = (LiteralCommandNode)var0;
            var4 = new c(var5.getLiteral());
            var2 |= 1;
        } else {
            throw new UnsupportedOperationException("Unknown node type " + var0);
        }
        var6 = var0.getChildren().stream().mapToInt(arg_0 -> var1.getInt(arg_0)).toArray();
        return new b(var4, var2, var3, (int[])var6);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommands(this);
    }

    public RootCommandNode<ICompletionProvider> getRoot(CommandBuildContext var0) {
        return (RootCommandNode)new d(var0, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean a(BiPredicate var0, List var1, IntSet var2, int var3) {
        return var0.test((b)var1.get(var3), var2);
    }

    static class b {
        @Nullable
        final e stub;
        final int flags;
        final int redirect;
        final int[] children;

        b(@Nullable e var0, int var1, int var2, int[] var3) {
            this.stub = var0;
            this.flags = var1;
            this.redirect = var2;
            this.children = var3;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeByte(this.flags);
            var0.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                var0.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(var0);
            }
        }

        public boolean canBuild(IntSet var0) {
            if ((this.flags & 8) != 0) {
                return !var0.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet var0) {
            for (int var4 : this.children) {
                if (!var0.contains(var4)) continue;
                return false;
            }
            return true;
        }
    }

    static interface e {
        public ArgumentBuilder<ICompletionProvider, ?> build(CommandBuildContext var1);

        public void write(PacketDataSerializer var1);
    }

    static class a
    implements e {
        private final String id;
        private final ArgumentTypeInfo.a<?> argumentType;
        @Nullable
        private final MinecraftKey suggestionId;

        @Nullable
        private static MinecraftKey getSuggestionId(@Nullable SuggestionProvider<ICompletionProvider> var0) {
            return var0 != null ? CompletionProviders.getName(var0) : null;
        }

        a(String var0, ArgumentTypeInfo.a<?> var1, @Nullable MinecraftKey var2) {
            this.id = var0;
            this.argumentType = var1;
            this.suggestionId = var2;
        }

        public a(ArgumentCommandNode<ICompletionProvider, ?> var0) {
            this(var0.getName(), ArgumentTypeInfos.unpack(var0.getType()), a.getSuggestionId((SuggestionProvider<ICompletionProvider>)var0.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<ICompletionProvider, ?> build(CommandBuildContext var0) {
            Object var1 = this.argumentType.instantiate(var0);
            RequiredArgumentBuilder var2 = RequiredArgumentBuilder.argument((String)this.id, var1);
            if (this.suggestionId != null) {
                var2.suggests(CompletionProviders.getProvider(this.suggestionId));
            }
            return var2;
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeUtf(this.id);
            a.serializeCap(var0, this.argumentType);
            if (this.suggestionId != null) {
                var0.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(PacketDataSerializer var0, ArgumentTypeInfo.a<A> var1) {
            a.serializeCap(var0, var1.type(), var1);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void serializeCap(PacketDataSerializer var0, ArgumentTypeInfo<A, T> var1, ArgumentTypeInfo.a<A> var2) {
            var0.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(var1));
            var1.serializeToNetwork(var2, var0);
        }
    }

    static class c
    implements e {
        private final String id;

        c(String var0) {
            this.id = var0;
        }

        @Override
        public ArgumentBuilder<ICompletionProvider, ?> build(CommandBuildContext var0) {
            return LiteralArgumentBuilder.literal((String)this.id);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeUtf(this.id);
        }
    }

    static class d {
        private final CommandBuildContext context;
        private final List<b> entries;
        private final List<CommandNode<ICompletionProvider>> nodes;

        d(CommandBuildContext var0, List<b> var1) {
            this.context = var0;
            this.entries = var1;
            ObjectArrayList var2 = new ObjectArrayList();
            var2.size(var1.size());
            this.nodes = var2;
        }

        public CommandNode<ICompletionProvider> resolve(int var02) {
            RootCommandNode var3;
            CommandNode<ICompletionProvider> var1 = this.nodes.get(var02);
            if (var1 != null) {
                return var1;
            }
            b var2 = this.entries.get(var02);
            if (var2.stub == null) {
                var3 = new RootCommandNode();
            } else {
                ArgumentBuilder<ICompletionProvider, ?> var4 = var2.stub.build(this.context);
                if ((var2.flags & 8) != 0) {
                    var4.redirect(this.resolve(var2.redirect));
                }
                if ((var2.flags & 4) != 0) {
                    var4.executes(var0 -> 0);
                }
                var3 = var4.build();
            }
            this.nodes.set(var02, (CommandNode<ICompletionProvider>)var3);
            for (int var7 : var2.children) {
                CommandNode<ICompletionProvider> var8 = this.resolve(var7);
                if (var8 instanceof RootCommandNode) continue;
                var3.addChild(var8);
            }
            return var3;
        }
    }
}

