/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import javax.annotation.Nullable;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.SignatureValidator;

@FunctionalInterface
public interface SignedMessageValidator {
    public static final SignedMessageValidator ACCEPT_UNSIGNED = var0 -> !var0.hasSignature();
    public static final SignedMessageValidator REJECT_ALL = var0 -> false;

    public boolean updateAndValidate(PlayerChatMessage var1);

    public static class a
    implements SignedMessageValidator {
        private final SignatureValidator validator;
        @Nullable
        private PlayerChatMessage lastMessage;
        private boolean isChainValid = true;

        public a(SignatureValidator var0) {
            this.validator = var0;
        }

        private boolean validateChain(PlayerChatMessage var0) {
            if (var0.equals(this.lastMessage)) {
                return true;
            }
            return this.lastMessage == null || var0.link().isDescendantOf(this.lastMessage.link());
        }

        @Override
        public boolean updateAndValidate(PlayerChatMessage var0) {
            boolean bl = this.isChainValid = this.isChainValid && var0.verify(this.validator) && this.validateChain(var0);
            if (!this.isChainValid) {
                return false;
            }
            this.lastMessage = var0;
            return true;
        }
    }
}

